/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.StackingRule;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface TransactionType {
    public static final TransactionType ADD = (inventory, itemStack, slotPredicate, start, end, step) -> {
        ItemStack inventoryItem;
        int i;
        Int2ObjectOpenHashMap<ItemStack> itemChangesMap = new Int2ObjectOpenHashMap<ItemStack>();
        StackingRule stackingRule = StackingRule.get();
        for (i = start; i < end; i += step) {
            int maxSize;
            int itemAmount;
            inventoryItem = inventory.getItemStack(i);
            if (inventoryItem.isAir() || !stackingRule.canBeStacked(itemStack, inventoryItem) || (itemAmount = stackingRule.getAmount(inventoryItem)) >= (maxSize = stackingRule.getMaxSize(inventoryItem)) || !slotPredicate.test(i, inventoryItem)) continue;
            int itemStackAmount = stackingRule.getAmount(itemStack);
            int totalAmount = itemStackAmount + itemAmount;
            if (!stackingRule.canApply(itemStack, totalAmount)) {
                itemChangesMap.put(i, stackingRule.apply(inventoryItem, maxSize));
                itemStack = stackingRule.apply(itemStack, totalAmount - maxSize);
                continue;
            }
            itemChangesMap.put(i, stackingRule.apply(inventoryItem, totalAmount));
            itemStack = stackingRule.apply(itemStack, 0);
            break;
        }
        for (i = start; i < end; i += step) {
            inventoryItem = inventory.getItemStack(i);
            if (!inventoryItem.isAir() || !slotPredicate.test(i, inventoryItem)) continue;
            itemChangesMap.put(i, itemStack);
            itemStack = stackingRule.apply(itemStack, 0);
            break;
        }
        return Pair.of(itemStack, itemChangesMap);
    };
    public static final TransactionType TAKE = (inventory, itemStack, slotPredicate, start, end, step) -> {
        Int2ObjectOpenHashMap<ItemStack> itemChangesMap = new Int2ObjectOpenHashMap<ItemStack>();
        StackingRule stackingRule = StackingRule.get();
        for (int i = start; i < end; i += step) {
            ItemStack inventoryItem = inventory.getItemStack(i);
            if (inventoryItem.isAir() || !stackingRule.canBeStacked(itemStack, inventoryItem) || !slotPredicate.test(i, inventoryItem)) continue;
            int itemAmount = stackingRule.getAmount(inventoryItem);
            int itemStackAmount = stackingRule.getAmount(itemStack);
            if (itemStackAmount < itemAmount) {
                itemChangesMap.put(i, stackingRule.apply(inventoryItem, itemAmount - itemStackAmount));
                itemStack = stackingRule.apply(itemStack, 0);
                break;
            }
            itemChangesMap.put(i, stackingRule.apply(inventoryItem, 0));
            itemStack = stackingRule.apply(itemStack, itemStackAmount - itemAmount);
            if (stackingRule.getAmount(itemStack) != 0) continue;
            itemStack = stackingRule.apply(itemStack, 0);
            break;
        }
        return Pair.of(itemStack, itemChangesMap);
    };

    @NotNull
    public Pair<ItemStack, Map<Integer, ItemStack>> process(@NotNull AbstractInventory var1, @NotNull ItemStack var2, @NotNull SlotPredicate var3, int var4, int var5, int var6);

    @NotNull
    default public Pair<ItemStack, Map<Integer, ItemStack>> process(@NotNull AbstractInventory inventory, @NotNull ItemStack itemStack, @NotNull SlotPredicate slotPredicate) {
        return this.process(inventory, itemStack, slotPredicate, 0, inventory.getInnerSize(), 1);
    }

    @NotNull
    default public Pair<ItemStack, Map<Integer, ItemStack>> process(@NotNull AbstractInventory inventory, @NotNull ItemStack itemStack) {
        return this.process(inventory, itemStack, (slot, itemStack1) -> true);
    }

    @FunctionalInterface
    public static interface SlotPredicate {
        public boolean test(int var1, @NotNull ItemStack var2);
    }
}

