/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface TransactionOption<T> {
    public static final TransactionOption<ItemStack> ALL = (inventory, result2, itemChangesMap) -> {
        itemChangesMap.forEach(inventory::safeItemInsert);
        return result2;
    };
    public static final TransactionOption<Boolean> ALL_OR_NOTHING = (inventory, result2, itemChangesMap) -> {
        if (result2.isAir()) {
            itemChangesMap.forEach(inventory::safeItemInsert);
            return true;
        }
        return false;
    };
    public static final TransactionOption<Boolean> DRY_RUN = (inventory, result2, itemChangesMap) -> result2.isAir();

    @NotNull
    public T fill(@NotNull AbstractInventory var1, @NotNull ItemStack var2, @NotNull @NotNull Map<@NotNull Integer, @NotNull ItemStack> var3);

    @NotNull
    default public T fill(@NotNull TransactionType type2, @NotNull AbstractInventory inventory, @NotNull ItemStack itemStack) {
        Pair<ItemStack, Map<Integer, ItemStack>> pair = type2.process(inventory, itemStack);
        return this.fill(inventory, pair.left(), pair.right());
    }
}

