/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.palette;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import net.minestom.server.MinecraftServer;
import net.minestom.server.instance.palette.AdaptivePalette;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.instance.palette.SpecializedPalette;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.NotNull;

final class FlexiblePalette
implements SpecializedPalette,
Cloneable {
    private static final ThreadLocal<int[]> WRITE_CACHE = ThreadLocal.withInitial(() -> new int[4096]);
    private final AdaptivePalette adaptivePalette;
    private byte bitsPerEntry;
    private int count;
    private long[] values;
    IntArrayList paletteToValueList;
    private Int2IntOpenHashMap valueToPaletteMap;

    FlexiblePalette(AdaptivePalette adaptivePalette, byte bitsPerEntry) {
        this.adaptivePalette = adaptivePalette;
        this.bitsPerEntry = bitsPerEntry;
        this.paletteToValueList = new IntArrayList(1);
        this.paletteToValueList.add(0);
        this.valueToPaletteMap = new Int2IntOpenHashMap(1);
        this.valueToPaletteMap.put(0, 0);
        this.valueToPaletteMap.defaultReturnValue(-1);
        int valuesPerLong = 64 / bitsPerEntry;
        this.values = new long[(this.maxSize() + valuesPerLong - 1) / valuesPerLong];
    }

    FlexiblePalette(AdaptivePalette adaptivePalette) {
        this(adaptivePalette, adaptivePalette.defaultBitsPerEntry);
    }

    @Override
    public int get(int x, int y, int z) {
        byte bitsPerEntry = this.bitsPerEntry;
        int sectionIndex = FlexiblePalette.getSectionIndex(this.dimension(), x, y, z);
        int valuesPerLong = 64 / bitsPerEntry;
        int index = sectionIndex / valuesPerLong;
        int bitIndex = (sectionIndex - index * valuesPerLong) * bitsPerEntry;
        int value = (int)(this.values[index] >> bitIndex) & (1 << bitsPerEntry) - 1;
        return this.hasPalette() ? this.paletteToValueList.getInt(value) : value;
    }

    @Override
    public void getAll(@NotNull Palette.EntryConsumer consumer) {
        this.retrieveAll(consumer, true);
    }

    @Override
    public void getAllPresent(@NotNull Palette.EntryConsumer consumer) {
        this.retrieveAll(consumer, false);
    }

    @Override
    public void set(int x, int y, int z, int value) {
        value = this.getPaletteIndex(value);
        byte bitsPerEntry = this.bitsPerEntry;
        long[] values2 = this.values;
        int valuesPerLong = 64 / bitsPerEntry;
        int sectionIndex = FlexiblePalette.getSectionIndex(this.dimension(), x, y, z);
        int index = sectionIndex / valuesPerLong;
        int bitIndex = (sectionIndex - index * valuesPerLong) * bitsPerEntry;
        long block = values2[index];
        long clear = (1L << bitsPerEntry) - 1L;
        long oldBlock = block >> bitIndex & clear;
        values2[index] = block & (clear << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << bitIndex;
        boolean currentAir = oldBlock == 0L;
        if (currentAir != (value == 0)) {
            this.count += currentAir ? 1 : -1;
        }
    }

    @Override
    public void fill(int value) {
        if (value == 0) {
            Arrays.fill(this.values, 0L);
            this.count = 0;
            return;
        }
        value = this.getPaletteIndex(value);
        byte bitsPerEntry = this.bitsPerEntry;
        int valuesPerLong = 64 / bitsPerEntry;
        long[] values2 = this.values;
        long block = 0L;
        for (int i = 0; i < valuesPerLong; ++i) {
            block |= (long)value << i * bitsPerEntry;
        }
        Arrays.fill(values2, block);
        this.count = this.maxSize();
    }

    @Override
    public void setAll(@NotNull Palette.EntrySupplier supplier) {
        int[] cache2 = WRITE_CACHE.get();
        int dimension = this.dimension();
        int fillValue = -1;
        int count2 = 0;
        int index = 0;
        for (int y = 0; y < dimension; ++y) {
            for (int z = 0; z < dimension; ++z) {
                for (int x = 0; x < dimension; ++x) {
                    int value = supplier.get(x, y, z);
                    if (fillValue != -2) {
                        if (fillValue == -1) {
                            fillValue = value;
                        } else if (fillValue != value) {
                            fillValue = -2;
                        }
                    }
                    if (value != 0) {
                        value = this.getPaletteIndex(value);
                        ++count2;
                    }
                    cache2[index++] = value;
                }
            }
        }
        assert (index == this.maxSize());
        if (fillValue < 0) {
            this.updateAll(cache2);
            this.count = count2;
        } else {
            this.fill(fillValue);
        }
    }

    @Override
    public void replace(int x, int y, int z, @NotNull IntUnaryOperator operator) {
        int newValue;
        int oldValue = this.get(x, y, z);
        if (oldValue != (newValue = operator.applyAsInt(oldValue))) {
            this.set(x, y, z, newValue);
        }
    }

    @Override
    public void replaceAll(@NotNull Palette.EntryFunction function) {
        int[] cache2 = WRITE_CACHE.get();
        AtomicInteger arrayIndex = new AtomicInteger();
        AtomicInteger count2 = new AtomicInteger();
        this.getAll((x, y, z, value) -> {
            int newValue = function.apply(x, y, z, value);
            int index = arrayIndex.getPlain();
            arrayIndex.setPlain(index + 1);
            int n = cache2[index] = newValue != value ? this.getPaletteIndex(newValue) : value;
            if (newValue != 0) {
                count2.setPlain(count2.getPlain() + 1);
            }
        });
        assert (arrayIndex.getPlain() == this.maxSize());
        this.updateAll(cache2);
        this.count = count2.getPlain();
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public int bitsPerEntry() {
        return this.bitsPerEntry;
    }

    @Override
    public int maxBitsPerEntry() {
        return this.adaptivePalette.maxBitsPerEntry();
    }

    @Override
    public int dimension() {
        return this.adaptivePalette.dimension();
    }

    @Override
    @NotNull
    public SpecializedPalette clone() {
        try {
            FlexiblePalette palette = (FlexiblePalette)super.clone();
            palette.values = this.values != null ? (long[])this.values.clone() : null;
            palette.paletteToValueList = this.paletteToValueList.clone();
            palette.valueToPaletteMap = this.valueToPaletteMap.clone();
            palette.count = this.count;
            return palette;
        }
        catch (CloneNotSupportedException e) {
            MinecraftServer.getExceptionManager().handleException(e);
            throw new IllegalStateException("Weird thing happened");
        }
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BYTE, this.bitsPerEntry);
        if (this.bitsPerEntry <= this.maxBitsPerEntry()) {
            writer.writeCollection(NetworkBuffer.VAR_INT, this.paletteToValueList);
        }
        writer.write(NetworkBuffer.LONG_ARRAY, this.values);
    }

    private void retrieveAll(@NotNull Palette.EntryConsumer consumer, boolean consumeEmpty) {
        if (!consumeEmpty && this.count == 0) {
            return;
        }
        long[] values2 = this.values;
        int dimension = this.dimension();
        byte bitsPerEntry = this.bitsPerEntry;
        int magicMask = (1 << bitsPerEntry) - 1;
        int valuesPerLong = 64 / bitsPerEntry;
        int size = this.maxSize();
        int dimensionMinus = dimension - 1;
        int[] ids = this.hasPalette() ? this.paletteToValueList.elements() : null;
        int dimensionBitCount = MathUtils.bitsToRepresent(dimensionMinus);
        int shiftedDimensionBitCount = dimensionBitCount << 1;
        for (int i = 0; i < values2.length; ++i) {
            long value = values2[i];
            int startIndex = i * valuesPerLong;
            int endIndex = Math.min(startIndex + valuesPerLong, size);
            for (int index = startIndex; index < endIndex; ++index) {
                int bitIndex = (index - startIndex) * bitsPerEntry;
                int paletteIndex = (int)(value >> bitIndex & (long)magicMask);
                if (!consumeEmpty && paletteIndex == 0) continue;
                int y = index >> shiftedDimensionBitCount;
                int z = index >> dimensionBitCount & dimensionMinus;
                int x = index & dimensionMinus;
                int result2 = ids != null ? ids[paletteIndex] : paletteIndex;
                consumer.accept(x, y, z, result2);
            }
        }
    }

    private void updateAll(int[] paletteValues) {
        int size = this.maxSize();
        assert (paletteValues.length >= size);
        byte bitsPerEntry = this.bitsPerEntry;
        int valuesPerLong = 64 / bitsPerEntry;
        long clear = (1L << bitsPerEntry) - 1L;
        long[] values2 = this.values;
        for (int i = 0; i < values2.length; ++i) {
            long block = values2[i];
            int startIndex = i * valuesPerLong;
            int endIndex = Math.min(startIndex + valuesPerLong, size);
            for (int index = startIndex; index < endIndex; ++index) {
                int bitIndex = (index - startIndex) * bitsPerEntry;
                block = block & (clear << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | (long)paletteValues[index] << bitIndex;
            }
            values2[i] = block;
        }
    }

    void resize(byte newBitsPerEntry) {
        newBitsPerEntry = (byte)(newBitsPerEntry > this.maxBitsPerEntry() ? 15 : (int)newBitsPerEntry);
        FlexiblePalette palette = new FlexiblePalette(this.adaptivePalette, newBitsPerEntry);
        palette.paletteToValueList = this.paletteToValueList;
        palette.valueToPaletteMap = this.valueToPaletteMap;
        this.getAll(palette::set);
        this.bitsPerEntry = palette.bitsPerEntry;
        this.values = palette.values;
        assert (this.count == palette.count);
    }

    private int getPaletteIndex(int value) {
        byte bpe;
        if (!this.hasPalette()) {
            return value;
        }
        int lastPaletteIndex = this.paletteToValueList.size();
        if (lastPaletteIndex >= FlexiblePalette.maxPaletteSize(bpe = this.bitsPerEntry)) {
            this.resize((byte)(bpe + 1));
            return this.getPaletteIndex(value);
        }
        int lookup = this.valueToPaletteMap.putIfAbsent(value, lastPaletteIndex);
        if (lookup != -1) {
            return lookup;
        }
        this.paletteToValueList.add(value);
        assert (lastPaletteIndex < FlexiblePalette.maxPaletteSize(bpe));
        return lastPaletteIndex;
    }

    boolean hasPalette() {
        return this.bitsPerEntry <= this.maxBitsPerEntry();
    }

    static int getSectionIndex(int dimension, int x, int y, int z) {
        int dimensionMask = dimension - 1;
        int dimensionBitCount = MathUtils.bitsToRepresent(dimensionMask);
        return (y & dimensionMask) << (dimensionBitCount << 1) | (z & dimensionMask) << dimensionBitCount | x & dimensionMask;
    }

    static int maxPaletteSize(int bitsPerEntry) {
        return 1 << bitsPerEntry;
    }
}

