/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.rule.vanilla;

import java.util.Map;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Player;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.block.rule.BlockPlacementRule;
import org.jetbrains.annotations.NotNull;

public class WallPlacementRule
extends BlockPlacementRule {
    public WallPlacementRule(@NotNull Block block) {
        super(block);
    }

    @Override
    @NotNull
    public Block blockUpdate(@NotNull Instance instance, @NotNull Point blockPosition, @NotNull Block block) {
        int x = blockPosition.blockX();
        int y = blockPosition.blockY();
        int z = blockPosition.blockZ();
        String east = "none";
        String north = "none";
        String south = "none";
        String up = "true";
        String waterlogged = "false";
        String west = "none";
        if (this.isBlock(instance, x + 1, y, z)) {
            east = "low";
        }
        if (this.isBlock(instance, x - 1, y, z)) {
            west = "low";
        }
        if (this.isBlock(instance, x, y, z + 1)) {
            south = "low";
        }
        if (this.isBlock(instance, x, y, z - 1)) {
            north = "low";
        }
        return block.withProperties(Map.of("east", east, "north", north, "south", south, "west", west, "up", up, "waterlogged", waterlogged));
    }

    @Override
    public Block blockPlace(@NotNull Instance instance, @NotNull Block block, @NotNull BlockFace blockFace, @NotNull Point blockPosition, @NotNull Player pl) {
        return block;
    }

    private boolean isBlock(Instance instance, int x, int y, int z) {
        return instance.getBlock(x, y, z).isSolid();
    }
}

