/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.rule.vanilla;

import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Player;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.block.rule.BlockPlacementRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StairsPlacementRule
extends BlockPlacementRule {
    public StairsPlacementRule(@NotNull Block block) {
        super(block);
    }

    @Override
    @NotNull
    public Block blockUpdate(@NotNull Instance instance, @NotNull Point blockPosition, @NotNull Block block) {
        return block;
    }

    @Override
    public Block blockPlace(@NotNull Instance instance, @NotNull Block block, @NotNull BlockFace blockFace, @NotNull Point blockPosition, @NotNull Player player) {
        Facing facing = this.getFacing(player);
        Shape shape = this.getShape(instance, blockPosition, facing);
        BlockFace half = BlockFace.BOTTOM;
        String waterlogged = "false";
        return block.withProperties(Map.of("facing", facing.toString(), "half", half.toString(), "shape", shape.toString(), "waterlogged", waterlogged));
    }

    @NotNull
    private Shape getShape(@NotNull Instance instance, @NotNull Point blockPosition, @NotNull Facing facing) {
        return null;
    }

    @Nullable
    private Shape getShapeFromSide(@NotNull Pair<Shape, Facing> side, @NotNull Facing facing, @NotNull Shape right, @NotNull Shape left) {
        if (side.left() == null) {
            return null;
        }
        Facing sideFacing = side.right();
        if (facing.equals((Object)Facing.NORTH)) {
            if (sideFacing.equals((Object)Facing.EAST)) {
                return right;
            }
            if (sideFacing.equals((Object)Facing.WEST)) {
                return left;
            }
        } else if (facing.equals((Object)Facing.SOUTH)) {
            if (sideFacing.equals((Object)Facing.EAST)) {
                return left;
            }
            if (sideFacing.equals((Object)Facing.WEST)) {
                return right;
            }
        } else if (facing.equals((Object)Facing.EAST)) {
            if (sideFacing.equals((Object)Facing.SOUTH)) {
                return right;
            }
            if (sideFacing.equals((Object)Facing.NORTH)) {
                return left;
            }
        } else if (facing.equals((Object)Facing.WEST)) {
            if (sideFacing.equals((Object)Facing.SOUTH)) {
                return left;
            }
            if (sideFacing.equals((Object)Facing.NORTH)) {
                return right;
            }
        }
        return null;
    }

    @NotNull
    private Facing getFacing(@NotNull Player player) {
        float degrees2 = (player.getPosition().yaw() - 90.0f) % 360.0f;
        if (degrees2 < 0.0f) {
            degrees2 += 360.0f;
        }
        if (0.0f <= degrees2 && degrees2 < 45.0f) {
            return Facing.WEST;
        }
        if (45.0f <= degrees2 && degrees2 < 135.0f) {
            return Facing.NORTH;
        }
        if (135.0f <= degrees2 && degrees2 < 225.0f) {
            return Facing.EAST;
        }
        if (225.0f <= degrees2 && degrees2 < 315.0f) {
            return Facing.SOUTH;
        }
        return Facing.WEST;
    }

    private static enum Facing {
        NORTH(new Vec(0.0, 0.0, 1.0), new Vec(0.0, 0.0, -1.0)),
        EAST(new Vec(-1.0, 0.0, 0.0), new Vec(1.0, 0.0, 0.0)),
        SOUTH(new Vec(0.0, 0.0, -1.0), new Vec(0.0, 0.0, 1.0)),
        WEST(new Vec(1.0, 0.0, 0.0), new Vec(-1.0, 0.0, 0.0));

        private final Point front;
        private final Point back;

        private Facing(Point front, Point back) {
            this.front = front;
            this.back = back;
        }

        public @NotNull Pair<@Nullable Shape, @Nullable Facing> getFront(@NotNull Instance instance, @NotNull Point blockPosition) {
            return null;
        }

        public @NotNull Pair<@Nullable Shape, @Nullable Facing> getBack(@NotNull Instance instance, @NotNull Point blockPosition) {
            return this.getProperties(instance, blockPosition.add(this.back));
        }

        private @NotNull Pair<@Nullable Shape, @Nullable Facing> getProperties(@NotNull Instance instance, @NotNull Point blockPosition) {
            Block block = instance.getBlock(blockPosition);
            if (block.isAir()) {
                return Pair.of(null, null);
            }
            Block state = instance.getBlock(blockPosition);
            try {
                return Pair.of(null, null);
            }
            catch (Exception ex) {
                return Pair.of(null, null);
            }
        }
    }

    private static enum Shape {
        STRAIGHT,
        OUTER_LEFT,
        OUTER_RIGHT,
        INNER_LEFT,
        INNER_RIGHT;

    }
}

