/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import net.minestom.server.instance.palette.Palette;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public final class Section
implements NetworkBuffer.Writer {
    private Palette blockPalette;
    private Palette biomePalette;
    private byte[] skyLight;
    private byte[] blockLight;

    private Section(Palette blockPalette, Palette biomePalette, byte[] skyLight, byte[] blockLight) {
        this.blockPalette = blockPalette;
        this.biomePalette = biomePalette;
        this.skyLight = skyLight;
        this.blockLight = blockLight;
    }

    public Section() {
        this(Palette.blocks(), Palette.biomes(), new byte[0], new byte[0]);
    }

    public Palette blockPalette() {
        return this.blockPalette;
    }

    public Palette biomePalette() {
        return this.biomePalette;
    }

    public byte[] getSkyLight() {
        return this.skyLight;
    }

    public void setSkyLight(byte[] skyLight) {
        this.skyLight = skyLight;
    }

    public byte[] getBlockLight() {
        return this.blockLight;
    }

    public void setBlockLight(byte[] blockLight) {
        this.blockLight = blockLight;
    }

    public void clear() {
        this.blockPalette.fill(0);
        this.biomePalette.fill(0);
        this.skyLight = new byte[0];
        this.blockLight = new byte[0];
    }

    @NotNull
    public Section clone() {
        return new Section(this.blockPalette.clone(), this.biomePalette.clone(), (byte[])this.skyLight.clone(), (byte[])this.blockLight.clone());
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.SHORT, (short)this.blockPalette.count());
        writer.write(this.blockPalette);
        writer.write(this.biomePalette);
    }
}

