/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minestom.server.Viewable;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.ExperienceOrb;
import net.minestom.server.entity.ItemEntity;
import net.minestom.server.entity.Player;
import net.minestom.server.instance.EntityTrackerImpl;
import net.minestom.server.instance.SharedInstance;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@ApiStatus.Experimental
public interface EntityTracker {
    @NotNull
    public static EntityTracker newTracker() {
        return new EntityTrackerImpl();
    }

    public <T extends Entity> void register(@NotNull Entity var1, @NotNull Point var2, @NotNull Target<T> var3, @Nullable Update<T> var4);

    public <T extends Entity> void unregister(@NotNull Entity var1, @NotNull Target<T> var2, @Nullable Update<T> var3);

    public <T extends Entity> void move(@NotNull Entity var1, @NotNull Point var2, @NotNull Target<T> var3, @Nullable Update<T> var4);

    public <T extends Entity> @UnmodifiableView Collection<T> chunkEntities(int var1, int var2, @NotNull Target<T> var3);

    default public <T extends Entity> @UnmodifiableView @NotNull Collection<T> chunkEntities(@NotNull Point point, @NotNull Target<T> target) {
        return this.chunkEntities(point.chunkX(), point.chunkZ(), target);
    }

    public <T extends Entity> void nearbyEntitiesByChunkRange(@NotNull Point var1, int var2, @NotNull Target<T> var3, @NotNull Consumer<T> var4);

    public <T extends Entity> void nearbyEntities(@NotNull Point var1, double var2, @NotNull Target<T> var4, @NotNull Consumer<T> var5);

    @NotNull
    public <T extends Entity> @UnmodifiableView @NotNull Set<@NotNull T> entities(@NotNull Target<T> var1);

    @NotNull
    default public @UnmodifiableView @NotNull Set<@NotNull Entity> entities() {
        return this.entities(Target.ENTITIES);
    }

    @NotNull
    public Viewable viewable(@NotNull @NotNull List<@NotNull SharedInstance> var1, int var2, int var3);

    @NotNull
    default public Viewable viewable(int chunkX, int chunkZ) {
        return this.viewable(List.of(), chunkX, chunkZ);
    }

    @ApiStatus.NonExtendable
    public static interface Target<E extends Entity> {
        public static final Target<Entity> ENTITIES = Target.create(Entity.class);
        public static final Target<Player> PLAYERS = Target.create(Player.class);
        public static final Target<ItemEntity> ITEMS = Target.create(ItemEntity.class);
        public static final Target<ExperienceOrb> EXPERIENCE_ORBS = Target.create(ExperienceOrb.class);
        public static final List<Target<? extends Entity>> TARGETS = List.of(ENTITIES, PLAYERS, ITEMS, EXPERIENCE_ORBS);

        public Class<E> type();

        public int ordinal();

        private static <T extends Entity> Target<T> create(final Class<T> type2) {
            final int ordinal = EntityTrackerImpl.TARGET_COUNTER.getAndIncrement();
            return new Target<T>(){

                @Override
                public Class<T> type() {
                    return type2;
                }

                @Override
                public int ordinal() {
                    return ordinal;
                }
            };
        }
    }

    public static interface Update<E extends Entity> {
        public void add(@NotNull E var1);

        public void remove(@NotNull E var1);

        default public void referenceUpdate(@NotNull Point point, @Nullable EntityTracker tracker) {
        }
    }
}

