/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.gamedata.tags;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minestom.server.entity.EntityType;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.Material;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Tag {
    private final NamespaceID name;
    private final Set<NamespaceID> values;

    public Tag(NamespaceID name2) {
        this.name = name2;
        this.values = new HashSet<NamespaceID>();
    }

    public Tag(NamespaceID name2, Set<NamespaceID> values2) {
        this.name = name2;
        this.values = new HashSet<NamespaceID>(values2);
    }

    public boolean contains(NamespaceID id2) {
        return this.values.contains(id2);
    }

    public Set<NamespaceID> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    public NamespaceID getName() {
        return this.name;
    }

    public static enum BasicType {
        BLOCKS("minecraft:block", Registry.Resource.BLOCK_TAGS, name2 -> Objects.requireNonNull(Block.fromNamespaceId(name2)).id()),
        ITEMS("minecraft:item", Registry.Resource.ITEM_TAGS, name2 -> Objects.requireNonNull(Material.fromNamespaceId(name2)).id()),
        FLUIDS("minecraft:fluid", Registry.Resource.FLUID_TAGS, name2 -> Registries.getFluid(name2).ordinal()),
        ENTITY_TYPES("minecraft:entity_type", Registry.Resource.ENTITY_TYPE_TAGS, name2 -> Objects.requireNonNull(EntityType.fromNamespaceId(name2)).id()),
        GAME_EVENTS("minecraft:game_event", Registry.Resource.GAMEPLAY_TAGS, name2 -> Registries.getFluid(name2).ordinal());

        private static final BasicType[] VALUES;
        private final String identifier;
        private final Registry.Resource resource;
        private final Function<String, Integer> function;

        private BasicType(@NotNull String identifier, Registry.Resource resource, Function<String, Integer> function) {
            this.identifier = identifier;
            this.resource = resource;
            this.function = function;
        }

        @NotNull
        public String getIdentifier() {
            return this.identifier;
        }

        public Registry.Resource getResource() {
            return this.resource;
        }

        public Function<String, Integer> getFunction() {
            return this.function;
        }

        @Nullable
        public static BasicType fromIdentifer(@NotNull String identifier) {
            for (BasicType value : VALUES) {
                if (!value.identifier.equals(identifier)) continue;
                return value;
            }
            return null;
        }

        static {
            VALUES = BasicType.values();
        }
    }
}

