/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.fluid;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.registry.Registries;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Fluid implements Keyed
{
    EMPTY(NamespaceID.from("minecraft:empty")),
    FLOWING_WATER(NamespaceID.from("minecraft:flowing_water")),
    WATER(NamespaceID.from("minecraft:water")),
    FLOWING_LAVA(NamespaceID.from("minecraft:flowing_lava")),
    LAVA(NamespaceID.from("minecraft:lava"));

    private static final Fluid[] VALUES;
    @NotNull
    private final NamespaceID id;

    private Fluid(NamespaceID id2) {
        this.id = id2;
        Registries.fluids.put(id2, this);
    }

    @Override
    @NotNull
    public Key key() {
        return this.id;
    }

    public short getId() {
        return (short)this.ordinal();
    }

    @NotNull
    public NamespaceID getNamespaceID() {
        return this.id;
    }

    @NotNull
    public String toString() {
        return "[" + this.id + "]";
    }

    @Nullable
    public static Fluid fromId(short id2) {
        if (id2 >= 0 && id2 < VALUES.length) {
            return VALUES[id2];
        }
        return null;
    }

    static {
        VALUES = Fluid.values();
    }
}

