/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.query.response;

import java.util.Objects;
import net.minestom.server.MinecraftServer;
import net.minestom.server.extras.query.Query;
import net.minestom.server.utils.binary.BinaryWriter;
import net.minestom.server.utils.binary.Writeable;
import org.jetbrains.annotations.NotNull;

public class BasicQueryResponse
implements Writeable {
    private String motd = "A Minestom Server";
    private String gametype = "SMP";
    private String map = "world";
    private String numPlayers = String.valueOf(MinecraftServer.getConnectionManager().getOnlinePlayers().size());
    private String maxPlayers = String.valueOf(Integer.parseInt(this.numPlayers) + 1);

    @NotNull
    public String getMotd() {
        return this.motd;
    }

    public void setMotd(@NotNull String motd) {
        this.motd = Objects.requireNonNull(motd, "motd");
    }

    @NotNull
    public String getGametype() {
        return this.gametype;
    }

    public void setGametype(@NotNull String gametype) {
        this.gametype = Objects.requireNonNull(gametype, "gametype");
    }

    @NotNull
    public String getMap() {
        return this.map;
    }

    public void setMap(@NotNull String map2) {
        this.map = Objects.requireNonNull(map2, "map");
    }

    @NotNull
    public String getNumPlayers() {
        return this.numPlayers;
    }

    public void setNumPlayers(@NotNull String numPlayers) {
        this.numPlayers = Objects.requireNonNull(numPlayers, "numPlayers");
    }

    public void setNumPlayers(int numPlayers) {
        this.setNumPlayers(String.valueOf(numPlayers));
    }

    @NotNull
    public String getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(@NotNull String maxPlayers) {
        this.maxPlayers = Objects.requireNonNull(maxPlayers, "maxPlayers");
    }

    public void setMaxPlayers(int maxPlayers) {
        this.setMaxPlayers(String.valueOf(maxPlayers));
    }

    @Override
    public void write(@NotNull BinaryWriter writer) {
        writer.writeNullTerminatedString(this.motd, Query.CHARSET);
        writer.writeNullTerminatedString(this.gametype, Query.CHARSET);
        writer.writeNullTerminatedString(this.map, Query.CHARSET);
        writer.writeNullTerminatedString(this.numPlayers, Query.CHARSET);
        writer.writeNullTerminatedString(this.maxPlayers, Query.CHARSET);
        writer.writeShort((short)MinecraftServer.getServer().getPort());
        writer.writeNullTerminatedString(Objects.requireNonNullElse(MinecraftServer.getServer().getAddress(), ""), Query.CHARSET);
    }
}

