/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extensions;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minestom.server.MinecraftServer;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventNode;
import net.minestom.server.extensions.DiscoveredExtension;
import org.jetbrains.annotations.NotNull;

public final class ExtensionClassLoader
extends URLClassLoader {
    private final List<ExtensionClassLoader> children = new ArrayList<ExtensionClassLoader>();
    private final DiscoveredExtension discoveredExtension;
    private EventNode<Event> eventNode;
    private ComponentLogger logger;

    public ExtensionClassLoader(String name2, URL[] urls, DiscoveredExtension discoveredExtension) {
        super("Ext_" + name2, urls, MinecraftServer.class.getClassLoader());
        this.discoveredExtension = discoveredExtension;
    }

    public ExtensionClassLoader(String name2, URL[] urls, ClassLoader parent, DiscoveredExtension discoveredExtension) {
        super("Ext_" + name2, urls, parent);
        this.discoveredExtension = discoveredExtension;
    }

    @Override
    public void addURL(@NotNull URL url2) {
        super.addURL(url2);
    }

    public void addChild(@NotNull ExtensionClassLoader loader) {
        this.children.add(loader);
    }

    @Override
    protected Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        try {
            return super.loadClass(name2, resolve2);
        }
        catch (ClassNotFoundException e) {
            for (ExtensionClassLoader child : this.children) {
                try {
                    return child.loadClass(name2, resolve2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw e;
        }
    }

    public InputStream getResourceAsStreamWithChildren(@NotNull String name2) {
        InputStream in = this.getResourceAsStream(name2);
        if (in != null) {
            return in;
        }
        for (ExtensionClassLoader child : this.children) {
            InputStream childInput = child.getResourceAsStreamWithChildren(name2);
            if (childInput == null) continue;
            return childInput;
        }
        return null;
    }

    public DiscoveredExtension getDiscoveredExtension() {
        return this.discoveredExtension;
    }

    public EventNode<Event> getEventNode() {
        if (this.eventNode == null) {
            this.eventNode = EventNode.all(this.discoveredExtension.getName());
            MinecraftServer.getGlobalEventHandler().addChild(this.eventNode);
        }
        return this.eventNode;
    }

    public ComponentLogger getLogger() {
        if (this.logger == null) {
            this.logger = ComponentLogger.logger(this.discoveredExtension.getName());
        }
        return this.logger;
    }

    void terminate() {
        if (this.eventNode != null) {
            MinecraftServer.getGlobalEventHandler().removeChild(this.eventNode);
        }
    }
}

