/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventNode;
import net.minestom.server.extensions.DiscoveredExtension;
import net.minestom.server.extensions.ExtensionClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Extension {
    protected final Set<String> dependents = new HashSet<String>();

    protected Extension() {
    }

    public void preInitialize() {
    }

    public abstract void initialize();

    public void postInitialize() {
    }

    public void preTerminate() {
    }

    public abstract void terminate();

    public void postTerminate() {
    }

    ExtensionClassLoader getExtensionClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof ExtensionClassLoader) {
            ExtensionClassLoader extensionClassLoader = (ExtensionClassLoader)classLoader;
            return extensionClassLoader;
        }
        throw new IllegalStateException("Extension class loader is not an ExtensionClassLoader");
    }

    @NotNull
    public DiscoveredExtension getOrigin() {
        return this.getExtensionClassLoader().getDiscoveredExtension();
    }

    @NotNull
    public ComponentLogger getLogger() {
        return this.getExtensionClassLoader().getLogger();
    }

    @NotNull
    public EventNode<Event> getEventNode() {
        return this.getExtensionClassLoader().getEventNode();
    }

    @NotNull
    public Path getDataDirectory() {
        return this.getOrigin().getDataDirectory();
    }

    @Nullable
    public InputStream getResource(@NotNull String fileName) {
        return this.getResource(Paths.get(fileName, new String[0]));
    }

    @Nullable
    public InputStream getResource(@NotNull Path target) {
        Path targetFile = this.getDataDirectory().resolve(target);
        try {
            if (!Files.exists(targetFile, new LinkOption[0])) {
                this.savePackagedResource(target);
            }
            return Files.newInputStream(targetFile, new OpenOption[0]);
        }
        catch (IOException ex) {
            this.getLogger().info("Failed to read resource {}.", (Object)target, (Object)ex);
            return null;
        }
    }

    @Nullable
    public InputStream getPackagedResource(@NotNull String fileName) {
        try {
            URL url2 = this.getOrigin().getClassLoader().getResource(fileName);
            if (url2 == null) {
                this.getLogger().debug("Resource not found: {}", (Object)fileName);
                return null;
            }
            return url2.openConnection().getInputStream();
        }
        catch (IOException ex) {
            this.getLogger().debug("Failed to load resource {}.", (Object)fileName, (Object)ex);
            return null;
        }
    }

    @Nullable
    public InputStream getPackagedResource(@NotNull Path target) {
        return this.getPackagedResource(target.toString().replace('\\', '/'));
    }

    public boolean savePackagedResource(@NotNull String fileName) {
        return this.savePackagedResource(Paths.get(fileName, new String[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean savePackagedResource(@NotNull Path target) {
        Path targetFile = this.getDataDirectory().resolve(target);
        try (InputStream is = this.getPackagedResource(target);){
            if (is == null) {
                boolean bl2 = false;
                return bl2;
            }
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
            Files.copy(is, targetFile, StandardCopyOption.REPLACE_EXISTING);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            this.getLogger().debug("Failed to save resource {}.", (Object)target, (Object)ex);
            return false;
        }
    }

    public Set<String> getDependents() {
        return this.dependents;
    }
}

