/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.server;

import java.time.Duration;
import net.minestom.server.event.trait.CancellableEvent;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.utils.time.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ClientPingServerEvent
implements CancellableEvent {
    private static final Duration DEFAULT_DELAY = Duration.of(0L, TimeUnit.MILLISECOND);
    private final PlayerConnection connection;
    private long payload;
    private boolean cancelled = false;
    private Duration delay;

    public ClientPingServerEvent(@NotNull PlayerConnection connection, long payload) {
        this.connection = connection;
        this.payload = payload;
        this.delay = DEFAULT_DELAY;
    }

    public ClientPingServerEvent(@NotNull PlayerConnection connection, long payload, Duration delay) {
        this.connection = connection;
        this.payload = payload;
        this.delay = delay;
    }

    @NotNull
    public PlayerConnection getConnection() {
        return this.connection;
    }

    public long getPayload() {
        return this.payload;
    }

    public void setPayload(long payload) {
        this.payload = payload;
    }

    @NotNull
    public Duration getDelay() {
        return this.delay;
    }

    public void addDelay(@NotNull Duration delay) {
        this.delay = this.delay.plus(delay);
    }

    public void setDelay(@NotNull Duration delay) {
        this.delay = delay;
    }

    public void noDelay() {
        this.delay = DEFAULT_DELAY;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

