/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventBinding;
import net.minestom.server.event.EventFilter;
import net.minestom.server.event.EventListener;
import net.minestom.server.event.EventNode;
import net.minestom.server.event.EventNodeImpl;
import org.jetbrains.annotations.NotNull;

final class EventNodeLazyImpl<E extends Event>
extends EventNodeImpl<E> {
    private static final VarHandle MAPPED;
    private final EventNodeImpl<? super E> holder;
    private final WeakReference<Object> owner;
    private boolean mapped;

    EventNodeLazyImpl(@NotNull EventNodeImpl<? super E> holder, @NotNull Object owner, @NotNull EventFilter<E, ?> filter2) {
        super(owner.toString(), filter2, null);
        this.holder = holder;
        this.owner = new WeakReference<Object>(owner);
    }

    @Override
    @NotNull
    public EventNode<E> addChild(@NotNull EventNode<? extends E> child) {
        this.ensureMap();
        return super.addChild(child);
    }

    @Override
    @NotNull
    public EventNode<E> addListener(@NotNull EventListener<? extends E> listener) {
        this.ensureMap();
        return super.addListener(listener);
    }

    @Override
    @NotNull
    public <E1 extends E> EventNode<E> addListener(@NotNull Class<E1> eventType, @NotNull @NotNull Consumer<@NotNull E1> listener) {
        this.ensureMap();
        return super.addListener(eventType, listener);
    }

    @Override
    @NotNull
    public <E1 extends E, H> EventNode<E1> map(@NotNull H value, @NotNull EventFilter<E1, H> filter2) {
        Object owner = this.retrieveOwner();
        if (owner != value) {
            throw new IllegalArgumentException("Cannot map an object to an already mapped node.");
        }
        return this;
    }

    @Override
    public void register(@NotNull EventBinding<? extends E> binding) {
        this.ensureMap();
        super.register(binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMap() {
        if (MAPPED.compareAndSet(this, false, true)) {
            Object object = GLOBAL_CHILD_LOCK;
            synchronized (object) {
                EventNodeImpl previous = this.holder.registeredMappedNode.putIfAbsent(this.retrieveOwner(), (EventNodeImpl)EventNodeImpl.class.cast(this));
                if (previous == null) {
                    this.invalidateEventsFor(this.holder);
                }
            }
        }
    }

    private Object retrieveOwner() {
        Object owner = this.owner.get();
        if (owner == null) {
            throw new IllegalStateException("Node handle is null. Be sure to never cache a local node.");
        }
        return owner;
    }

    static {
        try {
            MAPPED = MethodHandles.lookup().findVarHandle(EventNodeLazyImpl.class, "mapped", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }
}

