/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventBinding;
import net.minestom.server.event.EventFilter;
import net.minestom.server.event.EventListener;
import net.minestom.server.event.EventNode;
import net.minestom.server.event.EventNodeLazyImpl;
import net.minestom.server.event.ListenerHandle;
import net.minestom.server.event.trait.RecursiveEvent;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EventNodeImpl<T extends Event>
implements EventNode<T> {
    static final Object GLOBAL_CHILD_LOCK = new Object();
    private final Map<Class, Handle<T>> handleMap = new ConcurrentHashMap<Class, Handle<T>>();
    final Map<Class<? extends T>, ListenerEntry<T>> listenerMap = new ConcurrentHashMap<Class<? extends T>, ListenerEntry<T>>();
    final Set<EventNodeImpl<T>> children = new CopyOnWriteArraySet<EventNodeImpl<T>>();
    final Map<Object, EventNodeImpl<T>> mappedNodeCache = Caffeine.newBuilder().weakKeys().weakValues().build().asMap();
    final Map<Object, EventNodeImpl<T>> registeredMappedNode = Caffeine.newBuilder().weakKeys().weakValues().build().asMap();
    final String name;
    final EventFilter<T, ?> filter;
    final BiPredicate<T, Object> predicate;
    final Class<T> eventType;
    volatile int priority;
    volatile EventNodeImpl<? super T> parent;

    EventNodeImpl(@NotNull String name2, @NotNull EventFilter<T, ?> filter2, @Nullable BiPredicate<T, Object> predicate) {
        this.name = name2;
        this.filter = filter2;
        this.predicate = predicate;
        this.eventType = filter2.eventType();
    }

    @Override
    @NotNull
    public <E extends T> ListenerHandle<E> getHandle(@NotNull Class<E> handleType) {
        return this.handleMap.computeIfAbsent(handleType, aClass -> new Handle(aClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <E extends T> List<EventNode<E>> findChildren(@NotNull String name2, Class<E> eventType) {
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            Set<EventNode<T>> children2 = this.getChildren();
            if (children2.isEmpty()) {
                return List.of();
            }
            ArrayList<EventNode<EventNode<T>>> result2 = new ArrayList<EventNode<EventNode<T>>>();
            for (EventNode<T> child : children2) {
                if (EventNodeImpl.equals(child, name2, eventType)) {
                    result2.add(child);
                }
                result2.addAll(child.findChildren(name2, eventType));
            }
            return result2;
        }
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public @NotNull Set<@NotNull EventNode<T>> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends T> void replaceChildren(@NotNull String name2, @NotNull Class<E> eventType, @NotNull EventNode<E> eventNode) {
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            Set<EventNode<T>> children2 = this.getChildren();
            if (children2.isEmpty()) {
                return;
            }
            for (EventNode<T> child : children2) {
                if (EventNodeImpl.equals(child, name2, eventType)) {
                    this.removeChild(child);
                    this.addChild(eventNode);
                    break;
                }
                child.replaceChildren(name2, eventType, eventNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChildren(@NotNull String name2, @NotNull Class<? extends T> eventType) {
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            Set<EventNode<T>> children2 = this.getChildren();
            if (children2.isEmpty()) {
                return;
            }
            for (EventNode<? extends T> eventNode : children2) {
                if (EventNodeImpl.equals(eventNode, name2, eventType)) {
                    this.removeChild(eventNode);
                    continue;
                }
                eventNode.removeChildren(name2, eventType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public EventNode<T> addChild(@NotNull EventNode<? extends T> child) {
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            EventNodeImpl childImpl = (EventNodeImpl)child;
            Check.stateCondition(childImpl.parent != null, "Node already has a parent");
            Check.stateCondition(Objects.equals(this.parent, child), "Cannot have a child as parent");
            if (!this.children.add(childImpl)) {
                return this;
            }
            childImpl.parent = this;
            childImpl.invalidateEventsFor(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public EventNode<T> removeChild(@NotNull EventNode<? extends T> child) {
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            EventNodeImpl childImpl = (EventNodeImpl)child;
            boolean result2 = this.children.remove(childImpl);
            if (!result2) {
                return this;
            }
            childImpl.parent = null;
            childImpl.invalidateEventsFor(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public EventNode<T> addListener(@NotNull EventListener<? extends T> listener) {
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            Class<? extends T> eventType = listener.eventType();
            ListenerEntry<? extends T> entry2 = this.getEntry(eventType);
            entry2.listeners.add(listener);
            this.invalidateEvent(eventType);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public EventNode<T> removeListener(@NotNull EventListener<? extends T> listener) {
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            Class<? extends T> eventType = listener.eventType();
            ListenerEntry<T> entry2 = this.listenerMap.get(eventType);
            if (entry2 == null) {
                return this;
            }
            if (entry2.listeners.remove(listener)) {
                this.invalidateEvent(eventType);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <E extends T, H> EventNode<E> map(@NotNull H value, @NotNull EventFilter<E, H> filter2) {
        EventNodeLazyImpl<E> node;
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            node = new EventNodeLazyImpl<E>(this, value, filter2);
            Check.stateCondition(node.parent != null, "Node already has a parent");
            Check.stateCondition(Objects.equals(this.parent, node), "Cannot map to self");
            EventNodeImpl previous = this.mappedNodeCache.putIfAbsent(value, node);
            if (previous != null) {
                return previous;
            }
            node.parent = this;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmap(@NotNull Object value) {
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            EventNodeImpl<T> mappedNode = this.registeredMappedNode.remove(value);
            if (mappedNode != null) {
                mappedNode.invalidateEventsFor(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(@NotNull EventBinding<? extends T> binding) {
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            for (Class<Event> eventType : binding.eventTypes()) {
                ListenerEntry<Event> entry2 = this.getEntry(eventType);
                boolean added = entry2.bindingConsumers.add(binding.consumer(eventType));
                if (!added) continue;
                this.invalidateEvent(eventType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(@NotNull EventBinding<? extends T> binding) {
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            for (Class<Event> eventType : binding.eventTypes()) {
                ListenerEntry<T> entry2 = this.listenerMap.get(eventType);
                if (entry2 == null) {
                    return;
                }
                boolean removed = entry2.bindingConsumers.remove(binding.consumer(eventType));
                if (!removed) continue;
                this.invalidateEvent(eventType);
            }
        }
    }

    @Override
    @NotNull
    public Class<T> getEventType() {
        return this.eventType;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public EventNode<T> setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    @Nullable
    public EventNode<? super T> getParent() {
        return this.parent;
    }

    public String toString() {
        return EventNodeImpl.createStringGraph(this.createGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Graph createGraph() {
        Object object = GLOBAL_CHILD_LOCK;
        synchronized (object) {
            List<Graph> children2 = this.children.stream().map(EventNodeImpl::createGraph).toList();
            return new Graph(this.getName(), this.getEventType().getSimpleName(), this.getPriority(), children2);
        }
    }

    static String createStringGraph(Graph graph) {
        StringBuilder buffer = new StringBuilder();
        EventNodeImpl.genToStringTree(buffer, "", "", graph);
        return buffer.toString();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void genToStringTree(StringBuilder buffer, String prefix, String childrenPrefix, Graph graph) {
        buffer.append(prefix);
        buffer.append(String.format("%s - EventType: %s - Priority: %d", graph.name(), graph.eventType(), graph.priority()));
        buffer.append('\n');
        List<Graph> nextNodes = graph.children();
        Iterator<@NotNull Graph> iterator2 = nextNodes.iterator();
        while (iterator2.hasNext()) {
            Graph next = iterator2.next();
            if (iterator2.hasNext()) {
                EventNodeImpl.genToStringTree(buffer, childrenPrefix + "\u251c\u2500 ", childrenPrefix + "\u2502   ", next);
                continue;
            }
            EventNodeImpl.genToStringTree(buffer, childrenPrefix + "\u2514\u2500 ", childrenPrefix + "    ", next);
        }
    }

    void invalidateEventsFor(EventNodeImpl<? super T> node) {
        assert (Thread.holdsLock(GLOBAL_CHILD_LOCK));
        for (Class<? extends T> clazz : this.listenerMap.keySet()) {
            node.invalidateEvent(clazz);
        }
        for (EventNodeImpl eventNodeImpl : this.children) {
            eventNodeImpl.invalidateEventsFor(node);
        }
    }

    private void invalidateEvent(Class<? extends T> eventClass) {
        EventNodeImpl.forTargetEvents(eventClass, type2 -> {
            Handle handle = this.handleMap.computeIfAbsent((Class)type2, aClass -> new Handle(aClass));
            handle.invalidate();
        });
        EventNodeImpl<? extends T> parent = this.parent;
        if (parent != null) {
            parent.invalidateEvent(eventClass);
        }
    }

    private ListenerEntry<T> getEntry(Class<? extends T> type2) {
        return this.listenerMap.computeIfAbsent(type2, aClass -> new ListenerEntry());
    }

    private static boolean equals(EventNode<?> node, String name2, Class<?> eventType) {
        return node.getName().equals(name2) && eventType.isAssignableFrom(node.getEventType());
    }

    private static void forTargetEvents(Class<?> type2, Consumer<Class<?>> consumer) {
        Class<?> superclass;
        consumer.accept(type2);
        if (RecursiveEvent.class.isAssignableFrom(type2) && (superclass = type2.getSuperclass()) != null && RecursiveEvent.class.isAssignableFrom(superclass)) {
            EventNodeImpl.forTargetEvents(superclass, consumer);
        }
    }

    private static class ListenerEntry<T extends Event> {
        final List<EventListener<T>> listeners = new CopyOnWriteArrayList<EventListener<T>>();
        final Set<Consumer<T>> bindingConsumers = new CopyOnWriteArraySet<Consumer<T>>();

        private ListenerEntry() {
        }
    }

    record Graph(String name, String eventType, int priority, List<Graph> children) {
        public Graph {
            children2 = children2.stream().sorted(Comparator.comparingInt(Graph::priority)).toList();
        }
    }

    final class Handle<E extends Event>
    implements ListenerHandle<E> {
        private final Class<E> eventType;
        private Consumer<E> listener = null;
        private volatile boolean updated;

        Handle(Class<E> eventType) {
            this.eventType = eventType;
        }

        @Override
        public void call(@NotNull E event) {
            Consumer<E> listener = this.updatedListener();
            if (listener == null) {
                return;
            }
            try {
                listener.accept(event);
            }
            catch (Throwable e) {
                MinecraftServer.getExceptionManager().handleException(e);
            }
        }

        @Override
        public boolean hasListener() {
            return this.updatedListener() != null;
        }

        void invalidate() {
            this.updated = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        Consumer<E> updatedListener() {
            if (this.updated) {
                return this.listener;
            }
            Object object = GLOBAL_CHILD_LOCK;
            synchronized (object) {
                if (this.updated) {
                    return this.listener;
                }
                Consumer<E> listener = this.createConsumer();
                this.listener = listener;
                this.updated = true;
                return listener;
            }
        }

        @Nullable
        private Consumer<E> createConsumer() {
            boolean hasChildren;
            EventNodeImpl node = EventNodeImpl.this;
            ArrayList listeners = new ArrayList();
            EventNodeImpl.forTargetEvents(this.eventType, type2 -> {
                Consumer result2;
                ListenerEntry entry2 = node.listenerMap.get(type2);
                if (entry2 != null && (result2 = this.listenersConsumer(entry2)) != null) {
                    listeners.add(result2);
                }
            });
            Consumer[] listenersArray = (Consumer[])listeners.toArray(Consumer[]::new);
            Consumer mappedListener = this.mappedConsumer();
            Consumer[] childrenListeners = (Consumer[])node.children.stream().filter(child -> child.eventType.isAssignableFrom(this.eventType)).sorted(Comparator.comparing(EventNode::getPriority)).map(child -> ((Handle)child.getHandle(this.eventType)).updatedListener()).filter(Objects::nonNull).toArray(Consumer[]::new);
            BiPredicate predicate = node.predicate;
            EventFilter filter2 = node.filter;
            boolean hasPredicate = predicate != null;
            boolean hasListeners = listenersArray.length > 0;
            boolean hasMap = mappedListener != null;
            boolean bl = hasChildren = childrenListeners.length > 0;
            if (!(hasListeners || hasMap || hasChildren)) {
                return null;
            }
            return e -> {
                Object value;
                if (hasPredicate && !predicate.test(e, value = filter2.getHandler(e))) {
                    return;
                }
                if (hasListeners) {
                    for (Consumer listener : listenersArray) {
                        listener.accept(e);
                    }
                }
                if (hasMap) {
                    mappedListener.accept(e);
                }
                if (hasChildren) {
                    for (Consumer childHandle : childrenListeners) {
                        childHandle.accept(e);
                    }
                }
            };
        }

        @Nullable
        private Consumer<E> listenersConsumer(@NotNull ListenerEntry<E> entry2) {
            boolean bindingsEmpty;
            EventListener[] listenersCopy = (EventListener[])entry2.listeners.toArray(EventListener[]::new);
            Consumer[] bindingsCopy = (Consumer[])entry2.bindingConsumers.toArray(Consumer[]::new);
            boolean listenersEmpty = listenersCopy.length == 0;
            boolean bl = bindingsEmpty = bindingsCopy.length == 0;
            if (listenersEmpty && bindingsEmpty) {
                return null;
            }
            if (bindingsEmpty && listenersCopy.length == 1) {
                EventListener listener = listenersCopy[0];
                return e -> this.callListener(listener, e);
            }
            return e -> {
                if (!listenersEmpty) {
                    for (EventListener listener : listenersCopy) {
                        this.callListener(listener, e);
                    }
                }
                if (!bindingsEmpty) {
                    for (Consumer eConsumer : bindingsCopy) {
                        eConsumer.accept(e);
                    }
                }
            };
        }

        @Nullable
        private Consumer<E> mappedConsumer() {
            EventNodeImpl node = EventNodeImpl.this;
            Map mappedNodeCache = node.registeredMappedNode;
            if (mappedNodeCache.isEmpty()) {
                return null;
            }
            HashSet filters = new HashSet(mappedNodeCache.size());
            WeakHashMap<Object, Handle> handlers = new WeakHashMap<Object, Handle>(mappedNodeCache.size());
            for (Map.Entry mappedEntry : mappedNodeCache.entrySet()) {
                EventNodeImpl mappedNode = mappedEntry.getValue();
                Handle handle = (Handle)mappedNode.getHandle(this.eventType);
                if (!handle.hasListener()) continue;
                filters.add(mappedNode.filter);
                handlers.put(mappedEntry.getKey(), handle);
            }
            if (filters.isEmpty()) {
                return null;
            }
            EventFilter[] filterList = (EventFilter[])filters.toArray(EventFilter[]::new);
            BiConsumer<EventFilter, Event> mapper = (filter2, event) -> {
                Object handler = filter2.castHandler(event);
                Handle handle = (Handle)handlers.get(handler);
                if (handle != null) {
                    handle.call(event);
                }
            };
            return switch (filterList.length) {
                case 1 -> event -> mapper.accept(filterList[0], (Event)event);
                case 2 -> event -> {
                    mapper.accept(filterList[0], (Event)event);
                    mapper.accept(filterList[1], (Event)event);
                };
                case 3 -> event -> {
                    mapper.accept(filterList[0], (Event)event);
                    mapper.accept(filterList[1], (Event)event);
                    mapper.accept(filterList[2], (Event)event);
                };
                default -> event -> {
                    for (EventFilter filter2 : filterList) {
                        mapper.accept(filter2, (Event)event);
                    }
                };
            };
        }

        void callListener(@NotNull EventListener<E> listener, E event) {
            EventNodeImpl node = EventNodeImpl.this;
            EventListener.Result result2 = listener.run(event);
            if (result2 == EventListener.Result.EXPIRED) {
                node.removeListener(listener);
                this.invalidate();
            }
        }
    }
}

