/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventFilter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface EventBinding<E extends Event> {
    @NotNull
    public static <E extends Event, T> FilteredBuilder<E, T> filtered(@NotNull EventFilter<E, T> filter2, @NotNull Predicate<T> predicate) {
        return new FilteredBuilder<E, T>(filter2, predicate);
    }

    @NotNull
    public Collection<Class<? extends Event>> eventTypes();

    @NotNull
    public @NotNull Consumer<@NotNull E> consumer(@NotNull Class<? extends Event> var1);

    public static class FilteredBuilder<E extends Event, T> {
        private final EventFilter<E, T> filter;
        private final Predicate<T> predicate;
        private final Map<Class<? extends Event>, BiConsumer<Object, E>> mapped = new HashMap<Class<? extends Event>, BiConsumer<Object, E>>();

        FilteredBuilder(EventFilter<E, T> filter2, Predicate<T> predicate) {
            this.filter = filter2;
            this.predicate = predicate;
        }

        public <M extends E> FilteredBuilder<E, T> map(@NotNull Class<M> eventType, @NotNull @NotNull BiConsumer<@NotNull T, @NotNull M> consumer) {
            this.mapped.put(eventType, consumer);
            return this;
        }

        @NotNull
        public EventBinding<E> build() {
            Map<Class<Event>, BiConsumer<Object, E>> copy2 = Map.copyOf(this.mapped);
            final Set<Class<? extends Event>> eventTypes = copy2.keySet();
            final HashMap<Class<? extends Event>, Consumer<Event>> consumers = new HashMap<Class<? extends Event>, Consumer<Event>>(eventTypes.size());
            for (Class<? extends Event> eventType : eventTypes) {
                BiConsumer<Object, E> consumer = copy2.get(eventType);
                consumers.put(eventType, event -> {
                    T handler = this.filter.getHandler((Event)event);
                    if (!this.predicate.test(handler)) {
                        return;
                    }
                    consumer.accept(handler, event);
                });
            }
            return new EventBinding<E>(){

                @Override
                @NotNull
                public Collection<Class<? extends Event>> eventTypes() {
                    return eventTypes;
                }

                @Override
                @NotNull
                public Consumer<E> consumer(@NotNull Class<? extends Event> eventType) {
                    return (Consumer)consumers.get(eventType);
                }
            };
        }
    }
}

