/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding;

import com.extollit.gaming.ai.path.model.IBlockDescription;
import com.extollit.gaming.ai.path.model.IBlockObject;
import com.extollit.linalg.immutable.AxisAlignedBBox;
import net.minestom.server.collision.Shape;
import net.minestom.server.instance.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import space.vectrix.flare.fastutil.Short2ObjectSyncMap;

@ApiStatus.Internal
public final class PFBlock
implements IBlockDescription,
IBlockObject {
    private static final Short2ObjectSyncMap<PFBlock> BLOCK_DESCRIPTION_MAP = Short2ObjectSyncMap.hashmap();
    private final Block block;

    @NotNull
    public static PFBlock get(@NotNull Block block) {
        return BLOCK_DESCRIPTION_MAP.computeIfAbsent(block.stateId(), state -> new PFBlock(block));
    }

    PFBlock(Block block) {
        this.block = block;
    }

    @Override
    public AxisAlignedBBox bounds() {
        Shape shape = this.block.registry().collisionShape();
        return new AxisAlignedBBox(shape.relativeStart().x(), shape.relativeStart().y(), shape.relativeStart().z(), shape.relativeEnd().x(), shape.relativeEnd().y(), shape.relativeEnd().z());
    }

    @Override
    public boolean isFenceLike() {
        if (this.block.namespace().asString().contains("fence")) {
            return true;
        }
        return this.block.namespace().asString().endsWith("wall");
    }

    @Override
    public boolean isClimbable() {
        return this.block.compare(Block.LADDER) || this.block.namespace().asString().contains("vine");
    }

    @Override
    public boolean isDoor() {
        return this.block.namespace().asString().endsWith("door");
    }

    @Override
    public boolean isIntractable() {
        return false;
    }

    @Override
    public boolean isImpeding() {
        return this.block.isSolid();
    }

    @Override
    public boolean isFullyBounded() {
        Shape shape = this.block.registry().collisionShape();
        return shape.relativeStart().isZero() && shape.relativeEnd().x() == 1.0 && shape.relativeEnd().y() == 1.0 && shape.relativeEnd().z() == 1.0;
    }

    @Override
    public boolean isLiquid() {
        return this.block.isLiquid();
    }

    @Override
    public boolean isIncinerating() {
        return this.block == Block.LAVA || this.block == Block.FIRE || this.block == Block.SOUL_FIRE;
    }
}

