/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding;

import com.extollit.gaming.ai.path.HydrazinePathFinder;
import com.extollit.gaming.ai.path.PathOptions;
import com.extollit.gaming.ai.path.model.IPath;
import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.pathfinding.PFPathingEntity;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.WorldBorder;
import net.minestom.server.utils.chunk.ChunkUtils;
import net.minestom.server.utils.position.PositionUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Navigator {
    private final PFPathingEntity pathingEntity;
    private HydrazinePathFinder pathFinder;
    private Point pathPosition;
    private final Entity entity;

    public Navigator(@NotNull Entity entity) {
        this.entity = entity;
        this.pathingEntity = new PFPathingEntity(this);
    }

    public PhysicsResult moveTowards(@NotNull Point direction, double speed) {
        double dz;
        double dy;
        Pos position = this.entity.getPosition();
        double dx = direction.x() - position.x();
        double distSquared = dx * dx + (dy = direction.y() - position.y()) * dy + (dz = direction.z() - position.z()) * dz;
        if (speed > distSquared) {
            speed = distSquared;
        }
        double radians2 = Math.atan2(dz, dx);
        double speedX = Math.cos(radians2) * speed;
        double speedY = dy * speed;
        double speedZ = Math.sin(radians2) * speed;
        float yaw = PositionUtils.getLookYaw(dx, dz);
        float pitch = PositionUtils.getLookPitch(dx, dy, dz);
        PhysicsResult physicsResult = CollisionUtils.handlePhysics(this.entity, new Vec(speedX, speedY, speedZ));
        this.entity.refreshPosition(physicsResult.newPosition().withView(yaw, pitch));
        return physicsResult;
    }

    public void jump(float height) {
        this.entity.setVelocity(new Vec(0.0, height * 2.5f, 0.0));
    }

    public synchronized boolean setPathTo(@Nullable Point point, boolean bestEffort) {
        if (point != null && this.pathPosition != null && point.samePoint(this.pathPosition)) {
            return false;
        }
        Instance instance = this.entity.getInstance();
        if (this.pathFinder == null) {
            return false;
        }
        this.pathFinder.reset();
        if (point == null) {
            return false;
        }
        if (instance == null) {
            return false;
        }
        WorldBorder worldBorder = instance.getWorldBorder();
        if (!worldBorder.isInside(point)) {
            return false;
        }
        Chunk chunk = instance.getChunkAt(point);
        if (!ChunkUtils.isLoaded(chunk)) {
            return false;
        }
        PathOptions pathOptions = new PathOptions().targetingStrategy(bestEffort ? PathOptions.TargetingStrategy.gravitySnap : PathOptions.TargetingStrategy.none);
        IPath path = this.pathFinder.initiatePathTo(point.x(), point.y(), point.z(), pathOptions);
        boolean success = path != null;
        this.pathPosition = success ? point : null;
        return success;
    }

    public boolean setPathTo(@Nullable Point position) {
        return this.setPathTo(position, true);
    }

    @ApiStatus.Internal
    public synchronized void tick() {
        if (this.pathPosition == null) {
            return;
        }
        if (this.entity instanceof LivingEntity && ((LivingEntity)this.entity).isDead()) {
            return;
        }
        if (this.pathFinder.updatePathFor(this.pathingEntity) == null) {
            this.reset();
        }
    }

    @Nullable
    public Point getPathPosition() {
        return this.pathPosition;
    }

    @NotNull
    public Entity getEntity() {
        return this.entity;
    }

    @ApiStatus.Internal
    @NotNull
    public PFPathingEntity getPathingEntity() {
        return this.pathingEntity;
    }

    @ApiStatus.Internal
    public void setPathFinder(@Nullable HydrazinePathFinder pathFinder) {
        this.pathFinder = pathFinder;
    }

    private void reset() {
        this.pathPosition = null;
        this.pathFinder.reset();
    }
}

