/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.villager;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.villager.AbstractVillagerMeta;
import org.jetbrains.annotations.NotNull;

public class VillagerMeta
extends AbstractVillagerMeta {
    public static final byte OFFSET = 18;
    public static final byte MAX_OFFSET = 19;

    public VillagerMeta(@NotNull Entity entity, @NotNull Metadata metadata2) {
        super(entity, metadata2);
    }

    @NotNull
    public VillagerData getVillagerData() {
        int[] data2 = this.metadata.getIndex(18, null);
        if (data2 == null) {
            return new VillagerData(Type.PLAINS, Profession.NONE, Level.NOVICE);
        }
        return new VillagerData(Type.VALUES[data2[0]], Profession.VALUES[data2[1]], Level.VALUES[data2[2] - 1]);
    }

    public void setVillagerData(@NotNull VillagerData data2) {
        this.metadata.setIndex(18, Metadata.VillagerData(data2.type.ordinal(), data2.profession.ordinal(), data2.level.ordinal() + 1));
    }

    public static class VillagerData {
        private Type type;
        private Profession profession;
        private Level level;

        public VillagerData(@NotNull Type type2, @NotNull Profession profession, @NotNull Level level) {
            this.type = type2;
            this.profession = profession;
            this.level = level;
        }

        @NotNull
        public Type getType() {
            return this.type;
        }

        public void setType(@NotNull Type type2) {
            this.type = type2;
        }

        @NotNull
        public Profession getProfession() {
            return this.profession;
        }

        public void setProfession(@NotNull Profession profession) {
            this.profession = profession;
        }

        @NotNull
        public Level getLevel() {
            return this.level;
        }

        public void setLevel(@NotNull Level level) {
            this.level = level;
        }
    }

    public static enum Type {
        DESERT,
        JUNGLE,
        PLAINS,
        SAVANNA,
        SNOW,
        SWAMP,
        TAIGA;

        public static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }

    public static enum Profession {
        NONE,
        ARMORER,
        BUTCHER,
        CARTOGRAPHER,
        CLERIC,
        FARMER,
        FISHERMAN,
        FLETCHER,
        LEATHERWORKER,
        LIBRARIAN,
        NITWIT,
        UNEMPLOYED,
        MASON,
        SHEPHERD,
        TOOLSMITH,
        WEAPONSMITH;

        public static final Profession[] VALUES;

        static {
            VALUES = Profession.values();
        }
    }

    public static enum Level {
        NOVICE,
        APPRENTICE,
        JOURNEYMAN,
        EXPERT,
        MASTER;

        public static final Level[] VALUES;

        static {
            VALUES = Level.values();
        }
    }
}

