/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.other;

import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.LivingEntityMeta;
import org.jetbrains.annotations.NotNull;

public class ArmorStandMeta
extends LivingEntityMeta {
    public static final byte OFFSET = 15;
    public static final byte MAX_OFFSET = 22;
    private static final byte IS_SMALL_BIT = 1;
    private static final byte HAS_ARMS_BIT = 4;
    private static final byte HAS_NO_BASE_PLATE_BIT = 8;
    private static final byte IS_MARKER_BIT = 16;

    public ArmorStandMeta(@NotNull Entity entity, @NotNull Metadata metadata2) {
        super(entity, metadata2);
    }

    public boolean isSmall() {
        return this.getMaskBit(15, (byte)1);
    }

    public void setSmall(boolean value) {
        this.setMaskBit(15, (byte)1, value);
    }

    public boolean isHasArms() {
        return this.getMaskBit(15, (byte)4);
    }

    public void setHasArms(boolean value) {
        this.setMaskBit(15, (byte)4, value);
    }

    public boolean isHasNoBasePlate() {
        return this.getMaskBit(15, (byte)8);
    }

    public void setHasNoBasePlate(boolean value) {
        this.setMaskBit(15, (byte)8, value);
    }

    public boolean isMarker() {
        return this.getMaskBit(15, (byte)16);
    }

    public void setMarker(boolean value) {
        this.setMaskBit(15, (byte)16, value);
    }

    @NotNull
    public Vec getHeadRotation() {
        return this.metadata.getIndex(16, Vec.ZERO);
    }

    public void setHeadRotation(@NotNull Vec value) {
        this.metadata.setIndex(16, Metadata.Rotation(value));
    }

    @NotNull
    public Vec getBodyRotation() {
        return this.metadata.getIndex(17, Vec.ZERO);
    }

    public void setBodyRotation(@NotNull Vec value) {
        this.metadata.setIndex(17, Metadata.Rotation(value));
    }

    @NotNull
    public Vec getLeftArmRotation() {
        return this.metadata.getIndex(18, new Vec(-10.0, 0.0, -10.0));
    }

    public void setLeftArmRotation(@NotNull Vec value) {
        this.metadata.setIndex(18, Metadata.Rotation(value));
    }

    @NotNull
    public Vec getRightArmRotation() {
        return this.metadata.getIndex(19, new Vec(-15.0, 0.0, 10.0));
    }

    public void setRightArmRotation(@NotNull Vec value) {
        this.metadata.setIndex(19, Metadata.Rotation(value));
    }

    @NotNull
    public Vec getLeftLegRotation() {
        return this.metadata.getIndex(20, new Vec(-1.0, 0.0, -1.0));
    }

    public void setLeftLegRotation(@NotNull Vec value) {
        this.metadata.setIndex(20, Metadata.Rotation(value));
    }

    @NotNull
    public Vec getRightLegRotation() {
        return this.metadata.getIndex(21, new Vec(1.0, 0.0, 1.0));
    }

    public void setRightLegRotation(@NotNull Vec value) {
        this.metadata.setIndex(21, Metadata.Rotation(value));
    }
}

