/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.minecart;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.entity.metadata.ObjectDataProvider;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMinecartMeta
extends EntityMeta
implements ObjectDataProvider {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 14;

    protected AbstractMinecartMeta(@NotNull Entity entity, @NotNull Metadata metadata2) {
        super(entity, metadata2);
    }

    public int getShakingPower() {
        return this.metadata.getIndex(8, 0);
    }

    public void setShakingPower(int value) {
        this.metadata.setIndex(8, Metadata.VarInt(value));
    }

    public int getShakingDirection() {
        return this.metadata.getIndex(9, 1);
    }

    public void setShakingDirection(int value) {
        this.metadata.setIndex(9, Metadata.VarInt(value));
    }

    public float getShakingMultiplier() {
        return this.metadata.getIndex(10, Float.valueOf(0.0f)).floatValue();
    }

    public void setShakingMultiplier(float value) {
        this.metadata.setIndex(10, Metadata.Float(value));
    }

    public int getCustomBlockIdAndDamage() {
        return this.metadata.getIndex(11, 0);
    }

    public void setCustomBlockIdAndDamage(int value) {
        this.metadata.setIndex(11, Metadata.VarInt(value));
    }

    public int getCustomBlockYPosition() {
        return this.metadata.getIndex(12, 6);
    }

    public void setCustomBlockYPosition(int value) {
        this.metadata.setIndex(12, Metadata.VarInt(value));
    }

    @Override
    public boolean requiresVelocityPacketAtSpawn() {
        return true;
    }
}

