/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import java.util.UUID;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.animal.AnimalMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoxMeta
extends AnimalMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 21;
    private static final byte SITTING_BIT = 1;
    private static final byte CROUCHING_BIT = 4;
    private static final byte INTERESTED_BIT = 8;
    private static final byte POUNCING_BIT = 16;
    private static final byte SLEEPING_BIT = 32;
    private static final byte FACEPLANTED_BIT = 64;
    private static final byte DEFENDING_BIT = -128;

    public FoxMeta(@NotNull Entity entity, @NotNull Metadata metadata2) {
        super(entity, metadata2);
    }

    @NotNull
    public Type getType() {
        return Type.VALUES[this.metadata.getIndex(17, 0)];
    }

    public void setType(@NotNull Type type2) {
        this.metadata.setIndex(17, Metadata.VarInt(type2.ordinal()));
    }

    public boolean isSitting() {
        return this.getMaskBit(18, (byte)1);
    }

    public void setSitting(boolean value) {
        this.setMaskBit(18, (byte)1, value);
    }

    public boolean isFoxSneaking() {
        return this.getMaskBit(18, (byte)4);
    }

    public void setFoxSneaking(boolean value) {
        this.setMaskBit(18, (byte)4, value);
    }

    public boolean isInterested() {
        return this.getMaskBit(18, (byte)8);
    }

    public void setInterested(boolean value) {
        this.setMaskBit(18, (byte)8, value);
    }

    public boolean isPouncing() {
        return this.getMaskBit(18, (byte)16);
    }

    public void setPouncing(boolean value) {
        this.setMaskBit(18, (byte)16, value);
    }

    public boolean isSleeping() {
        return this.getMaskBit(18, (byte)32);
    }

    public void setSleeping(boolean value) {
        this.setMaskBit(18, (byte)32, value);
    }

    public boolean isFaceplanted() {
        return this.getMaskBit(18, (byte)64);
    }

    public void setFaceplanted(boolean value) {
        this.setMaskBit(18, (byte)64, value);
    }

    public boolean isDefending() {
        return this.getMaskBit(18, (byte)-128);
    }

    public void setDefending(boolean value) {
        this.setMaskBit(18, (byte)-128, value);
    }

    @Nullable
    public UUID getFirstUUID() {
        return this.metadata.getIndex(19, null);
    }

    public void setFirstUUID(@Nullable UUID value) {
        this.metadata.setIndex(19, Metadata.OptUUID(value));
    }

    @Nullable
    public UUID getSecondUUID() {
        return this.metadata.getIndex(20, null);
    }

    public void setSecondUUID(@Nullable UUID value) {
        this.metadata.setIndex(20, Metadata.OptUUID(value));
    }

    public static enum Type {
        RED,
        SNOW;

        private static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

