/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata;

import net.minestom.server.collision.BoundingBox;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.PathfinderMobMeta;
import org.jetbrains.annotations.NotNull;

public class AgeableMobMeta
extends PathfinderMobMeta {
    public static final byte OFFSET = 16;
    public static final byte MAX_OFFSET = 17;

    protected AgeableMobMeta(@NotNull Entity entity, @NotNull Metadata metadata2) {
        super(entity, metadata2);
    }

    public boolean isBaby() {
        return this.metadata.getIndex(16, false);
    }

    public void setBaby(boolean value) {
        if (this.isBaby() == value) {
            return;
        }
        this.consumeEntity(entity -> {
            BoundingBox bb = entity.getBoundingBox();
            if (value) {
                double width = bb.width() / 2.0;
                entity.setBoundingBox(width, bb.height() / 2.0, width);
            } else {
                double width = bb.width() * 2.0;
                entity.setBoundingBox(width, bb.height() * 2.0, width);
            }
        });
        this.metadata.setIndex(16, Metadata.Boolean(value));
    }
}

