/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.fakeplayer;

import java.util.List;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.fakeplayer.FakePlayer;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.play.ClientAnimationPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCloseWindowPacket;
import net.minestom.server.network.packet.client.play.ClientHeldItemChangePacket;
import net.minestom.server.network.packet.client.play.ClientInteractEntityPacket;
import net.minestom.server.network.packet.client.play.ClientKeepAlivePacket;
import net.minestom.server.network.packet.client.play.ClientPlayerDiggingPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerRotationPacket;
import net.minestom.server.network.packet.client.play.ClientPluginMessagePacket;
import net.minestom.server.network.packet.client.play.ClientTeleportConfirmPacket;
import net.minestom.server.network.packet.client.play.ClientUseItemPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.play.KeepAlivePacket;
import net.minestom.server.network.packet.server.play.PlayerPositionAndLookPacket;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public class FakePlayerController {
    private final FakePlayer fakePlayer;

    public FakePlayerController(@NotNull FakePlayer fakePlayer) {
        this.fakePlayer = fakePlayer;
    }

    public void clickWindow(boolean playerInventory, short slot, byte button, ClientClickWindowPacket.ClickType clickType) {
        Inventory inventory = playerInventory ? null : this.fakePlayer.getOpenInventory();
        Inventory abstractInventory = inventory == null ? this.fakePlayer.getInventory() : inventory;
        playerInventory = abstractInventory instanceof PlayerInventory;
        slot = playerInventory ? (short)PlayerInventoryUtils.convertToPacketSlot(slot) : slot;
        ItemStack itemStack = abstractInventory.getItemStack(slot);
        this.addToQueue(new ClientClickWindowPacket(playerInventory ? (byte)0 : inventory.getWindowId(), 0, slot, button, clickType, List.of(), itemStack));
    }

    public void closeWindow() {
        Inventory openInventory = this.fakePlayer.getOpenInventory();
        this.addToQueue(new ClientCloseWindowPacket(openInventory == null ? (byte)0 : openInventory.getWindowId()));
    }

    public void sendPluginMessage(String channel, byte[] message) {
        this.addToQueue(new ClientPluginMessagePacket(channel, message));
    }

    public void sendPluginMessage(String channel, String message) {
        this.sendPluginMessage(channel, message.getBytes());
    }

    public void attackEntity(Entity entity) {
        this.addToQueue(new ClientInteractEntityPacket(entity.getEntityId(), new ClientInteractEntityPacket.Attack(), this.fakePlayer.isSneaking()));
    }

    public void respawn() {
        this.fakePlayer.respawn();
    }

    public void setHeldItem(short slot) {
        Check.argCondition(!MathUtils.isBetween(slot, 0, 8), "Slot has to be between 0 and 8!");
        this.addToQueue(new ClientHeldItemChangePacket(slot));
    }

    public void sendArmAnimation(Player.Hand hand) {
        this.addToQueue(new ClientAnimationPacket(hand));
    }

    public void useItem(Player.Hand hand) {
        this.addToQueue(new ClientUseItemPacket(hand, 0));
    }

    public void rotate(float yaw, float pitch) {
        this.addToQueue(new ClientPlayerRotationPacket(yaw, pitch, this.fakePlayer.isOnGround()));
    }

    public void startDigging(Point blockPosition, BlockFace blockFace) {
        this.addToQueue(new ClientPlayerDiggingPacket(ClientPlayerDiggingPacket.Status.STARTED_DIGGING, blockPosition, blockFace, 0));
    }

    public void stopDigging(Point blockPosition, BlockFace blockFace) {
        this.addToQueue(new ClientPlayerDiggingPacket(ClientPlayerDiggingPacket.Status.CANCELLED_DIGGING, blockPosition, blockFace, 0));
    }

    public void finishDigging(Point blockPosition, BlockFace blockFace) {
        this.addToQueue(new ClientPlayerDiggingPacket(ClientPlayerDiggingPacket.Status.FINISHED_DIGGING, blockPosition, blockFace, 0));
    }

    public void consumePacket(ServerPacket serverPacket) {
        if (serverPacket instanceof PlayerPositionAndLookPacket) {
            PlayerPositionAndLookPacket playerPositionAndLookPacket = (PlayerPositionAndLookPacket)serverPacket;
            this.addToQueue(new ClientTeleportConfirmPacket(playerPositionAndLookPacket.teleportId()));
        } else if (serverPacket instanceof KeepAlivePacket) {
            KeepAlivePacket keepAlivePacket = (KeepAlivePacket)serverPacket;
            this.addToQueue(new ClientKeepAlivePacket(keepAlivePacket.id()));
        }
    }

    private void addToQueue(ClientPacket clientPlayPacket) {
        this.fakePlayer.addPacketToQueue(clientPlayPacket);
    }
}

