/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.damage;

import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.damage.EntityDamage;
import net.minestom.server.entity.damage.EntityProjectileDamage;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.Taggable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageType
implements Taggable {
    public static final DamageType VOID = new DamageType("attack.outOfWorld");
    public static final DamageType GRAVITY = new DamageType("attack.fall");
    public static final DamageType ON_FIRE = new DamageType("attack.onFire"){

        @Override
        protected SoundEvent getPlayerSound(@NotNull Player player) {
            return SoundEvent.ENTITY_PLAYER_HURT_ON_FIRE;
        }
    };
    private final String identifier;
    private final TagHandler tagHandler = TagHandler.newHandler();

    public DamageType(@NotNull String identifier) {
        this.identifier = identifier;
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public Component buildDeathMessage(@NotNull Player killed) {
        return Component.translatable("death." + this.identifier, Component.text(killed.getUsername()));
    }

    @NotNull
    public static DamageType fromProjectile(@Nullable Entity shooter, @NotNull Entity projectile) {
        return new EntityProjectileDamage(shooter, projectile);
    }

    @NotNull
    public static EntityDamage fromPlayer(@NotNull Player player) {
        return new EntityDamage(player);
    }

    @NotNull
    public static EntityDamage fromEntity(@NotNull Entity entity) {
        return new EntityDamage(entity);
    }

    @Nullable
    public Component buildDeathScreenText(@NotNull Player killed) {
        return Component.translatable("death." + this.identifier);
    }

    @Nullable
    public SoundEvent getSound(@NotNull LivingEntity entity) {
        if (entity instanceof Player) {
            return this.getPlayerSound((Player)entity);
        }
        return this.getGenericSound(entity);
    }

    protected SoundEvent getGenericSound(@NotNull LivingEntity entity) {
        return SoundEvent.ENTITY_GENERIC_HURT;
    }

    protected SoundEvent getPlayerSound(@NotNull Player player) {
        return SoundEvent.ENTITY_PLAYER_HURT;
    }

    @Override
    @NotNull
    public TagHandler tagHandler() {
        return this.tagHandler;
    }
}

