/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai.target;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.ai.TargetSelector;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.damage.EntityDamage;
import org.jetbrains.annotations.NotNull;

public class LastEntityDamagerTarget
extends TargetSelector {
    private final float range;

    public LastEntityDamagerTarget(@NotNull EntityCreature entityCreature, float range) {
        super(entityCreature);
        this.range = range;
    }

    @Override
    public Entity findTarget() {
        DamageType damageType = this.entityCreature.getLastDamageSource();
        if (!(damageType instanceof EntityDamage)) {
            return null;
        }
        EntityDamage entityDamage = (EntityDamage)damageType;
        Entity entity = entityDamage.getSource();
        if (entity.isRemoved()) {
            return null;
        }
        return this.entityCreature.getDistance(entity) < (double)this.range ? entity : null;
    }
}

