/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai;

import java.lang.ref.WeakReference;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.ai.EntityAIGroup;
import net.minestom.server.entity.ai.TargetSelector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoalSelector {
    private WeakReference<EntityAIGroup> aiGroupWeakReference;
    protected EntityCreature entityCreature;

    public GoalSelector(@NotNull EntityCreature entityCreature) {
        this.entityCreature = entityCreature;
    }

    public abstract boolean shouldStart();

    public abstract void start();

    public abstract void tick(long var1);

    public abstract boolean shouldEnd();

    public abstract void end();

    @Nullable
    public Entity findTarget() {
        EntityAIGroup aiGroup = this.getAIGroup();
        if (aiGroup == null) {
            return null;
        }
        for (TargetSelector targetSelector : aiGroup.getTargetSelectors()) {
            Entity entity = targetSelector.findTarget();
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    @NotNull
    public EntityCreature getEntityCreature() {
        return this.entityCreature;
    }

    public void setEntityCreature(@NotNull EntityCreature entityCreature) {
        this.entityCreature = entityCreature;
    }

    void setAIGroup(@NotNull EntityAIGroup group) {
        this.aiGroupWeakReference = new WeakReference<EntityAIGroup>(group);
    }

    @Nullable
    protected EntityAIGroup getAIGroup() {
        return (EntityAIGroup)this.aiGroupWeakReference.get();
    }
}

