/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import net.kyori.adventure.text.Component;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.Direction;
import net.minestom.server.utils.collection.ObjectArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;
import org.jglrxavpok.hephaistos.nbt.NBTEnd;

final class MetadataImpl {
    static final ObjectArray<Metadata.Entry<?>> EMPTY_VALUES = ObjectArray.singleThread(20);

    MetadataImpl() {
    }

    static {
        EMPTY_VALUES.set(0, Metadata.Byte((byte)0));
        EMPTY_VALUES.set(1, Metadata.VarInt(0));
        EMPTY_VALUES.set(2, Metadata.Float(0.0f));
        EMPTY_VALUES.set(3, Metadata.String(""));
        EMPTY_VALUES.set(4, Metadata.Chat(Component.empty()));
        EMPTY_VALUES.set(5, Metadata.OptChat(null));
        EMPTY_VALUES.set(6, Metadata.Slot(ItemStack.AIR));
        EMPTY_VALUES.set(7, Metadata.Boolean(false));
        EMPTY_VALUES.set(8, Metadata.Rotation(Vec.ZERO));
        EMPTY_VALUES.set(9, Metadata.Position(Vec.ZERO));
        EMPTY_VALUES.set(10, Metadata.OptPosition(null));
        EMPTY_VALUES.set(11, Metadata.Direction(Direction.DOWN));
        EMPTY_VALUES.set(12, Metadata.OptUUID(null));
        EMPTY_VALUES.set(13, Metadata.OptBlockID(null));
        EMPTY_VALUES.set(14, Metadata.NBT(NBTEnd.INSTANCE));
        EMPTY_VALUES.set(16, Metadata.VillagerData(0, 0, 0));
        EMPTY_VALUES.set(17, Metadata.OptVarInt(null));
        EMPTY_VALUES.set(18, Metadata.Pose(Entity.Pose.STANDING));
        EMPTY_VALUES.trim();
    }

    record EntryImpl<T>(int type, @UnknownNullability T value, @NotNull NetworkBuffer.Type<T> serializer) implements Metadata.Entry<T>
    {
        static Metadata.Entry<?> read(int type2, @NotNull NetworkBuffer reader) {
            EntryImpl value = (EntryImpl)EMPTY_VALUES.get(type2);
            if (value == null) {
                throw new UnsupportedOperationException("Unknown value type: " + type2);
            }
            return value.withValue(reader);
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.type);
            writer.write(this.serializer, this.value);
        }

        private EntryImpl<T> withValue(@NotNull NetworkBuffer reader) {
            return new EntryImpl<T>(this.type, reader.read(this.serializer), this.serializer);
        }
    }
}

