/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataImpl;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.play.EntityMetaDataPacket;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jglrxavpok.hephaistos.nbt.NBT;

public final class Metadata {
    public static final byte TYPE_BYTE = 0;
    public static final byte TYPE_VARINT = 1;
    public static final byte TYPE_FLOAT = 2;
    public static final byte TYPE_STRING = 3;
    public static final byte TYPE_CHAT = 4;
    public static final byte TYPE_OPTCHAT = 5;
    public static final byte TYPE_SLOT = 6;
    public static final byte TYPE_BOOLEAN = 7;
    public static final byte TYPE_ROTATION = 8;
    public static final byte TYPE_POSITION = 9;
    public static final byte TYPE_OPTPOSITION = 10;
    public static final byte TYPE_DIRECTION = 11;
    public static final byte TYPE_OPTUUID = 12;
    public static final byte TYPE_OPTBLOCKID = 13;
    public static final byte TYPE_NBT = 14;
    public static final byte TYPE_PARTICLE = 15;
    public static final byte TYPE_VILLAGERDATA = 16;
    public static final byte TYPE_OPTVARINT = 17;
    public static final byte TYPE_POSE = 18;
    private static final VarHandle NOTIFIED_CHANGES;
    private final Entity entity;
    private volatile Entry<?>[] entries = new Entry[0];
    private volatile Map<Integer, Entry<?>> entryMap = null;
    private volatile boolean notifyAboutChanges = true;
    private final Map<Integer, Entry<?>> notNotifiedChanges = new HashMap();

    public static Entry<Byte> Byte(byte value) {
        return new MetadataImpl.EntryImpl<Byte>(0, value, NetworkBuffer.BYTE);
    }

    public static Entry<Integer> VarInt(int value) {
        return new MetadataImpl.EntryImpl<Integer>(1, value, NetworkBuffer.VAR_INT);
    }

    public static Entry<Float> Float(float value) {
        return new MetadataImpl.EntryImpl<Float>(2, Float.valueOf(value), NetworkBuffer.FLOAT);
    }

    public static Entry<String> String(@NotNull String value) {
        return new MetadataImpl.EntryImpl<String>(3, value, NetworkBuffer.STRING);
    }

    public static Entry<Component> Chat(@NotNull Component value) {
        return new MetadataImpl.EntryImpl<Component>(4, value, NetworkBuffer.COMPONENT);
    }

    public static Entry<Component> OptChat(@Nullable Component value) {
        return new MetadataImpl.EntryImpl<Component>(5, value, NetworkBuffer.OPT_CHAT);
    }

    public static Entry<ItemStack> Slot(@NotNull ItemStack value) {
        return new MetadataImpl.EntryImpl<ItemStack>(6, value, NetworkBuffer.ITEM);
    }

    public static Entry<Boolean> Boolean(boolean value) {
        return new MetadataImpl.EntryImpl<Boolean>(7, value, NetworkBuffer.BOOLEAN);
    }

    public static Entry<Point> Rotation(@NotNull Point value) {
        return new MetadataImpl.EntryImpl<Point>(8, value, NetworkBuffer.ROTATION);
    }

    public static Entry<Point> Position(@NotNull Point value) {
        return new MetadataImpl.EntryImpl<Point>(9, value, NetworkBuffer.BLOCK_POSITION);
    }

    public static Entry<Point> OptPosition(@Nullable Point value) {
        return new MetadataImpl.EntryImpl<Point>(10, value, NetworkBuffer.OPT_BLOCK_POSITION);
    }

    public static Entry<Direction> Direction(@NotNull Direction value) {
        return new MetadataImpl.EntryImpl<Direction>(11, value, NetworkBuffer.DIRECTION);
    }

    public static Entry<UUID> OptUUID(@Nullable UUID value) {
        return new MetadataImpl.EntryImpl<UUID>(12, value, NetworkBuffer.OPT_UUID);
    }

    public static Entry<Integer> OptBlockID(@Nullable Integer value) {
        return new MetadataImpl.EntryImpl<Integer>(13, value, NetworkBuffer.OPT_BLOCK_ID);
    }

    public static Entry<NBT> NBT(@NotNull NBT nbt) {
        return new MetadataImpl.EntryImpl<NBT>(14, nbt, NetworkBuffer.NBT);
    }

    public static Entry<int[]> VillagerData(int villagerType, int villagerProfession, int level) {
        return new MetadataImpl.EntryImpl<int[]>(16, new int[]{villagerType, villagerProfession, level}, NetworkBuffer.VILLAGER_DATA);
    }

    public static Entry<Integer> OptVarInt(@Nullable Integer value) {
        return new MetadataImpl.EntryImpl<Integer>(17, value, NetworkBuffer.OPT_VAR_INT);
    }

    public static Entry<Entity.Pose> Pose(@NotNull Entity.Pose value) {
        return new MetadataImpl.EntryImpl<Entity.Pose>(18, value, NetworkBuffer.POSE);
    }

    public Metadata(@Nullable Entity entity) {
        this.entity = entity;
    }

    public <T> T getIndex(int index, @Nullable T defaultValue) {
        Entry<?>[] entries2 = this.entries;
        if (index < 0 || index >= entries2.length) {
            return defaultValue;
        }
        Entry<?> entry2 = entries2[index];
        return (T)(entry2 != null ? entry2.value() : defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndex(int index, @NotNull Entry<?> entry2) {
        Entry<?>[] entries2 = this.entries;
        if (index >= entries2.length) {
            int newLength = Math.max(entries2.length * 2, index + 1);
            this.entries = entries2 = Arrays.copyOf(entries2, newLength);
        }
        entries2[index] = entry2;
        this.entryMap = null;
        Entity entity = this.entity;
        if (entity != null && entity.isActive()) {
            if (!this.notifyAboutChanges) {
                Map<Integer, Entry<?>> map2 = this.notNotifiedChanges;
                synchronized (map2) {
                    this.notNotifiedChanges.put(index, entry2);
                }
            } else {
                entity.sendPacketToViewersAndSelf(new EntityMetaDataPacket(entity.getEntityId(), Map.of(index, entry2)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyAboutChanges(boolean notifyAboutChanges) {
        Map<Integer, Entry<?>> entries2;
        if (!NOTIFIED_CHANGES.compareAndSet(this, !notifyAboutChanges, notifyAboutChanges)) {
            return;
        }
        if (!notifyAboutChanges) {
            return;
        }
        Entity entity = this.entity;
        if (entity == null || !entity.isActive()) {
            return;
        }
        Map<Integer, Entry<?>> map2 = this.notNotifiedChanges;
        synchronized (map2) {
            Map<Integer, Entry<?>> awaitingChanges = this.notNotifiedChanges;
            if (awaitingChanges.isEmpty()) {
                return;
            }
            entries2 = Map.copyOf(awaitingChanges);
            awaitingChanges.clear();
        }
        entity.sendPacketToViewersAndSelf(new EntityMetaDataPacket(entity.getEntityId(), entries2));
    }

    @NotNull
    public Map<Integer, Entry<?>> getEntries() {
        Map<Integer, Entry<?>> map2 = this.entryMap;
        if (map2 == null) {
            map2 = new HashMap();
            Entry<?>[] entries2 = this.entries;
            for (int i = 0; i < entries2.length; ++i) {
                Entry<?> entry2 = entries2[i];
                if (entry2 == null) continue;
                map2.put(i, entry2);
            }
            this.entryMap = Map.copyOf(map2);
        }
        return map2;
    }

    static {
        try {
            NOTIFIED_CHANGES = MethodHandles.lookup().findVarHandle(Metadata.class, "notifyAboutChanges", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Entry<T>
    extends NetworkBuffer.Writer {
        public int type();

        public @UnknownNullability T value();

        @ApiStatus.Internal
        @NotNull
        public static Entry<?> read(int type2, @NotNull NetworkBuffer reader) {
            return MetadataImpl.EntryImpl.read(type2, reader);
        }
    }
}

