/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import com.extollit.gaming.ai.path.HydrazinePathFinder;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.ai.EntityAI;
import net.minestom.server.entity.ai.EntityAIGroup;
import net.minestom.server.entity.pathfinding.NavigableEntity;
import net.minestom.server.entity.pathfinding.Navigator;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.entity.EntityAttackEvent;
import net.minestom.server.instance.Instance;
import net.minestom.server.utils.time.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCreature
extends LivingEntity
implements NavigableEntity,
EntityAI {
    private int removalAnimationDelay = 1000;
    private final Set<EntityAIGroup> aiGroups = new CopyOnWriteArraySet<EntityAIGroup>();
    private final Navigator navigator = new Navigator(this);
    private Entity target;

    public EntityCreature(@NotNull EntityType entityType, @NotNull UUID uuid) {
        super(entityType, uuid);
        this.heal();
    }

    public EntityCreature(@NotNull EntityType entityType) {
        this(entityType, UUID.randomUUID());
    }

    @Override
    public void update(long time) {
        this.aiTick(time);
        this.navigator.tick();
        super.update(time);
    }

    @Override
    public CompletableFuture<Void> setInstance(@NotNull Instance instance, @NotNull Pos spawnPosition) {
        this.navigator.setPathFinder(new HydrazinePathFinder(this.navigator.getPathingEntity(), instance.getInstanceSpace()));
        return super.setInstance(instance, spawnPosition);
    }

    @Override
    public void kill() {
        super.kill();
        if (this.removalAnimationDelay > 0) {
            this.scheduleRemove(Duration.of(this.removalAnimationDelay, TimeUnit.MILLISECOND));
        } else {
            this.remove();
        }
    }

    public int getRemovalAnimationDelay() {
        return this.removalAnimationDelay;
    }

    public void setRemovalAnimationDelay(int removalAnimationDelay) {
        this.removalAnimationDelay = removalAnimationDelay;
    }

    @Override
    public Collection<EntityAIGroup> getAIGroups() {
        return this.aiGroups;
    }

    @Nullable
    public Entity getTarget() {
        return this.target;
    }

    public void setTarget(@Nullable Entity target) {
        this.target = target;
    }

    @Override
    @NotNull
    public Navigator getNavigator() {
        return this.navigator;
    }

    public void attack(@NotNull Entity target, boolean swingHand) {
        if (swingHand) {
            this.swingMainHand();
        }
        EntityAttackEvent attackEvent = new EntityAttackEvent(this, target);
        EventDispatcher.call(attackEvent);
    }

    public void attack(@NotNull Entity target) {
        this.attack(target, false);
    }
}

