/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.crypto;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.function.Consumer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Player;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.crypto.KeyUtils;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface SignatureValidator {
    public static final SignatureValidator PASS = (payload, signature2) -> true;
    public static final SignatureValidator FAIL = (payload, signature2) -> false;
    public static final SignatureValidator YGGDRASIL = SignatureValidator.createYggdrasilValidator();

    public boolean validate(byte[] var1, byte[] var2);

    default public boolean validate(Consumer<NetworkBuffer> payload, byte[] signature2) {
        return this.validate(NetworkBuffer.makeArray(payload), signature2);
    }

    public static SignatureValidator from(PublicKey publicKey, KeyUtils.SignatureAlgorithm algorithm) {
        return (payload, signature2) -> {
            try {
                Signature sig = Signature.getInstance(algorithm.name());
                sig.initVerify(publicKey);
                sig.update(payload);
                return sig.verify(signature2);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                return false;
            }
        };
    }

    @Nullable
    public static SignatureValidator from(Player player) {
        if (player.getPlayerConnection().playerPublicKey() == null) {
            return null;
        }
        return SignatureValidator.from(player.getPlayerConnection().playerPublicKey().publicKey(), KeyUtils.SignatureAlgorithm.SHA256withRSA);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SignatureValidator createYggdrasilValidator() {
        try (InputStream stream = SignatureValidator.class.getResourceAsStream("/yggdrasil_session_pubkey.der");){
            if (stream == null) {
                MinecraftServer.LOGGER.error("Couldn't find Yggdrasil public key, falling back to prohibiting validator!");
                SignatureValidator signatureValidator2 = FAIL;
                return signatureValidator2;
            }
            SignatureValidator signatureValidator = SignatureValidator.from(KeyUtils.publicRSAKeyFrom(stream.readAllBytes()), KeyUtils.SignatureAlgorithm.SHA1withRSA);
            return signatureValidator;
        }
        catch (Exception e) {
            MinecraftServer.LOGGER.error("Exception while reading Yggdrasil public key, falling back to prohibiting validator!", (Throwable)e);
            return FAIL;
        }
    }
}

