/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.parser;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.arguments.ArgumentBoolean;
import net.minestom.server.command.builder.arguments.ArgumentCommand;
import net.minestom.server.command.builder.arguments.ArgumentLiteral;
import net.minestom.server.command.builder.arguments.ArgumentString;
import net.minestom.server.command.builder.arguments.ArgumentStringArray;
import net.minestom.server.command.builder.arguments.ArgumentWord;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentBlockState;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentColor;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentComponent;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentEntity;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentFloatRange;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentIntRange;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentItemStack;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentNbtCompoundTag;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentNbtTag;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentResourceLocation;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentTime;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentUUID;
import net.minestom.server.command.builder.arguments.minecraft.registry.ArgumentEnchantment;
import net.minestom.server.command.builder.arguments.minecraft.registry.ArgumentEntityType;
import net.minestom.server.command.builder.arguments.minecraft.registry.ArgumentParticle;
import net.minestom.server.command.builder.arguments.minecraft.registry.ArgumentPotionEffect;
import net.minestom.server.command.builder.arguments.number.ArgumentDouble;
import net.minestom.server.command.builder.arguments.number.ArgumentFloat;
import net.minestom.server.command.builder.arguments.number.ArgumentInteger;
import net.minestom.server.command.builder.arguments.relative.ArgumentRelativeBlockPosition;
import net.minestom.server.command.builder.arguments.relative.ArgumentRelativeVec2;
import net.minestom.server.command.builder.arguments.relative.ArgumentRelativeVec3;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgumentParser {
    private static final Map<String, Function<String, Argument<?>>> ARGUMENT_FUNCTION_MAP = new ConcurrentHashMap();

    @ApiStatus.Experimental
    @NotNull
    public static Argument<?>[] generate(@NotNull String format) {
        String argument;
        ArrayList<Argument> result2 = new ArrayList<Argument>();
        boolean state = false;
        Function<String, Argument<?>> argumentFunction = null;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (!state) {
                String argument2;
                if (c == ' ') {
                    argument2 = builder.toString();
                    if (argument2.length() == 0) continue;
                    result2.add(new ArgumentLiteral(argument2));
                    builder = new StringBuilder();
                    continue;
                }
                if (c == '<') {
                    argument2 = builder.toString();
                    argumentFunction = ARGUMENT_FUNCTION_MAP.get(argument2.toLowerCase(Locale.ROOT));
                    if (argumentFunction == null) {
                        throw new IllegalArgumentException("error invalid argument name: " + argument2);
                    }
                    builder = new StringBuilder();
                    state = true;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (!state) continue;
            if (c == '>') {
                String param = builder.toString();
                Argument argument3 = (Argument)argumentFunction.apply(param);
                result2.add(argument3);
                builder = new StringBuilder();
                state = false;
                continue;
            }
            builder.append(c);
        }
        if (!state && (argument = builder.toString()).length() != 0) {
            result2.add(new ArgumentLiteral(argument));
        }
        return (Argument[])result2.toArray(Argument[]::new);
    }

    @Nullable
    public static ArgumentResult validate(@NotNull Argument<?> argument, @NotNull Argument<?>[] arguments2, int argIndex, @NotNull String[] inputArguments, int inputIndex) {
        boolean end;
        boolean bl = end = inputIndex == inputArguments.length;
        if (end) {
            return null;
        }
        Object parsedValue = null;
        ArgumentSyntaxException argumentSyntaxException = null;
        boolean correct = false;
        String rawArg = null;
        if (argument.useRemaining()) {
            boolean hasArgs;
            boolean bl2 = hasArgs = inputArguments.length > inputIndex;
            if (hasArgs) {
                StringBuilder builder = new StringBuilder();
                for (int i = inputIndex; i < inputArguments.length; ++i) {
                    String arg = inputArguments[i];
                    if (builder.length() > 0) {
                        builder.append(" ");
                    }
                    builder.append(arg);
                }
                rawArg = builder.toString();
                try {
                    parsedValue = argument.parse(rawArg);
                    correct = true;
                }
                catch (ArgumentSyntaxException exception) {
                    argumentSyntaxException = exception;
                }
            }
        } else {
            StringBuilder builder = new StringBuilder();
            for (int i = inputIndex; i < inputArguments.length; ++i) {
                builder.append(inputArguments[i]);
                rawArg = builder.toString();
                try {
                    boolean lastArgumentIteration;
                    parsedValue = argument.parse(rawArg);
                    boolean bl3 = lastArgumentIteration = argIndex + 1 == arguments2.length;
                    if (lastArgumentIteration && i + 1 < inputArguments.length) {
                        if (!argument.allowSpace()) break;
                        builder.append(" ");
                        continue;
                    }
                    correct = true;
                    inputIndex = i + 1;
                    break;
                }
                catch (ArgumentSyntaxException exception) {
                    argumentSyntaxException = exception;
                    if (!argument.allowSpace()) {
                        for (int j = i + 1; j < inputArguments.length; ++j) {
                            String arg = inputArguments[j];
                            if (builder.length() > 0) {
                                builder.append(" ");
                            }
                            builder.append(arg);
                        }
                        rawArg = builder.toString();
                        break;
                    }
                    builder.append(" ");
                }
            }
        }
        ArgumentResult argumentResult = new ArgumentResult();
        argumentResult.argument = argument;
        argumentResult.correct = correct;
        argumentResult.inputIndex = inputIndex;
        argumentResult.argumentSyntaxException = argumentSyntaxException;
        argumentResult.useRemaining = argument.useRemaining();
        argumentResult.rawArg = rawArg;
        argumentResult.parsedValue = parsedValue;
        return argumentResult;
    }

    static {
        ARGUMENT_FUNCTION_MAP.put("literal", ArgumentLiteral::new);
        ARGUMENT_FUNCTION_MAP.put("boolean", ArgumentBoolean::new);
        ARGUMENT_FUNCTION_MAP.put("integer", ArgumentInteger::new);
        ARGUMENT_FUNCTION_MAP.put("double", ArgumentDouble::new);
        ARGUMENT_FUNCTION_MAP.put("float", ArgumentFloat::new);
        ARGUMENT_FUNCTION_MAP.put("string", ArgumentString::new);
        ARGUMENT_FUNCTION_MAP.put("word", ArgumentWord::new);
        ARGUMENT_FUNCTION_MAP.put("stringarray", ArgumentStringArray::new);
        ARGUMENT_FUNCTION_MAP.put("command", ArgumentCommand::new);
        ARGUMENT_FUNCTION_MAP.put("color", ArgumentColor::new);
        ARGUMENT_FUNCTION_MAP.put("time", ArgumentTime::new);
        ARGUMENT_FUNCTION_MAP.put("enchantment", ArgumentEnchantment::new);
        ARGUMENT_FUNCTION_MAP.put("particle", ArgumentParticle::new);
        ARGUMENT_FUNCTION_MAP.put("resourcelocation", ArgumentResourceLocation::new);
        ARGUMENT_FUNCTION_MAP.put("potion", ArgumentPotionEffect::new);
        ARGUMENT_FUNCTION_MAP.put("entitytype", ArgumentEntityType::new);
        ARGUMENT_FUNCTION_MAP.put("blockstate", ArgumentBlockState::new);
        ARGUMENT_FUNCTION_MAP.put("intrange", ArgumentIntRange::new);
        ARGUMENT_FUNCTION_MAP.put("floatrange", ArgumentFloatRange::new);
        ARGUMENT_FUNCTION_MAP.put("entity", s2 -> new ArgumentEntity((String)s2).singleEntity(true));
        ARGUMENT_FUNCTION_MAP.put("entities", ArgumentEntity::new);
        ARGUMENT_FUNCTION_MAP.put("player", s2 -> new ArgumentEntity((String)s2).singleEntity(true).onlyPlayers(true));
        ARGUMENT_FUNCTION_MAP.put("players", s2 -> new ArgumentEntity((String)s2).onlyPlayers(true));
        ARGUMENT_FUNCTION_MAP.put("itemstack", ArgumentItemStack::new);
        ARGUMENT_FUNCTION_MAP.put("component", ArgumentComponent::new);
        ARGUMENT_FUNCTION_MAP.put("uuid", ArgumentUUID::new);
        ARGUMENT_FUNCTION_MAP.put("nbt", ArgumentNbtTag::new);
        ARGUMENT_FUNCTION_MAP.put("nbtcompound", ArgumentNbtCompoundTag::new);
        ARGUMENT_FUNCTION_MAP.put("relativeblockposition", ArgumentRelativeBlockPosition::new);
        ARGUMENT_FUNCTION_MAP.put("relativevec3", ArgumentRelativeVec3::new);
        ARGUMENT_FUNCTION_MAP.put("relativevec2", ArgumentRelativeVec2::new);
    }

    public static class ArgumentResult {
        public Argument<?> argument;
        public boolean correct;
        public int inputIndex;
        public ArgumentSyntaxException argumentSyntaxException;
        public boolean useRemaining;
        public String rawArg;
        public Object parsedValue;
    }
}

