/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import java.util.UUID;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import org.jetbrains.annotations.NotNull;

public class ArgumentUUID
extends Argument<UUID> {
    public static final int INVALID_UUID = -1;

    public ArgumentUUID(@NotNull String id2) {
        super(id2);
    }

    @Override
    @NotNull
    public UUID parse(@NotNull String input) throws ArgumentSyntaxException {
        try {
            return UUID.fromString(input);
        }
        catch (IllegalArgumentException exception) {
            throw new ArgumentSyntaxException("Invalid UUID", input, -1);
        }
    }

    @Override
    public String parser() {
        return "minecraft:uuid";
    }

    public String toString() {
        return String.format("UUID<%s>", this.getId());
    }
}

