/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import java.io.StringReader;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTException;
import org.jglrxavpok.hephaistos.parser.SNBTParser;

public class ArgumentItemStack
extends Argument<ItemStack> {
    public static final int NO_MATERIAL = 1;
    public static final int INVALID_NBT = 2;
    public static final int INVALID_MATERIAL = 3;

    public ArgumentItemStack(String id2) {
        super(id2, true);
    }

    @Override
    @NotNull
    public ItemStack parse(@NotNull String input) throws ArgumentSyntaxException {
        return ArgumentItemStack.staticParse(input);
    }

    @Override
    public String parser() {
        return "minecraft:item_stack";
    }

    @Deprecated
    public static ItemStack staticParse(@NotNull String input) throws ArgumentSyntaxException {
        NBTCompound compound;
        int nbtIndex = input.indexOf("{");
        if (nbtIndex == 0) {
            throw new ArgumentSyntaxException("The item needs a material", input, 1);
        }
        if (nbtIndex == -1) {
            Material material = Material.fromNamespaceId(input);
            if (material == null) {
                throw new ArgumentSyntaxException("Material is invalid", input, 3);
            }
            return ItemStack.of(material);
        }
        String materialName = input.substring(0, nbtIndex);
        Material material = Material.fromNamespaceId(materialName);
        if (material == null) {
            throw new ArgumentSyntaxException("Material is invalid", input, 3);
        }
        String sNBT = input.substring(nbtIndex).replace("\\\"", "\"");
        try {
            compound = (NBTCompound)new SNBTParser(new StringReader(sNBT)).parse();
        }
        catch (NBTException e) {
            throw new ArgumentSyntaxException("Item NBT is invalid", input, 2);
        }
        return ItemStack.fromNBT(material, compound);
    }

    public String toString() {
        return String.format("ItemStack<%s>", this.getId());
    }
}

