/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments;

import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.utils.binary.BinaryWriter;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgumentWord
extends Argument<String> {
    public static final int SPACE_ERROR = 1;
    public static final int RESTRICTION_ERROR = 2;
    protected String[] restrictions;

    public ArgumentWord(String id2) {
        super(id2);
    }

    @NotNull
    public ArgumentWord from(String ... restrictions) {
        if (restrictions != null) {
            for (String restriction : restrictions) {
                Check.notNull(restriction, "ArgumentWord restriction cannot be null, you can pass 'null' instead of an empty array");
            }
        }
        this.restrictions = restrictions;
        return this;
    }

    @Override
    @NotNull
    public String parse(@NotNull String input) throws ArgumentSyntaxException {
        if (input.contains(" ")) {
            throw new ArgumentSyntaxException("Word cannot contain space character", input, 1);
        }
        if (this.hasRestrictions()) {
            for (String r : this.restrictions) {
                if (!input.equals(r)) continue;
                return input;
            }
            throw new ArgumentSyntaxException("Word needs to be in the restriction list", input, 2);
        }
        return input;
    }

    @Override
    public String parser() {
        return "brigadier:string";
    }

    @Override
    public byte @Nullable [] nodeProperties() {
        return BinaryWriter.makeArray(packetWriter -> packetWriter.writeVarInt(0));
    }

    public boolean hasRestrictions() {
        return this.restrictions != null && this.restrictions.length > 0;
    }

    @Nullable
    public String[] getRestrictions() {
        return this.restrictions;
    }

    public String toString() {
        return String.format("Word<%s>", this.getId());
    }
}

