/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments;

import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.utils.StringUtils;
import net.minestom.server.utils.binary.BinaryWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgumentString
extends Argument<String> {
    private static final char BACKSLASH = '\\';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char QUOTE = '\'';
    public static final int QUOTE_ERROR = 1;

    public ArgumentString(String id2) {
        super(id2, true);
    }

    @Override
    @NotNull
    public String parse(@NotNull String input) throws ArgumentSyntaxException {
        return ArgumentString.staticParse(input);
    }

    @Override
    public String parser() {
        return "brigadier:string";
    }

    @Override
    public byte @Nullable [] nodeProperties() {
        return BinaryWriter.makeArray(packetWriter -> packetWriter.writeVarInt(1));
    }

    @Deprecated
    public static String staticParse(@NotNull String input) throws ArgumentSyntaxException {
        boolean quote;
        if (!(input.contains(String.valueOf('\"')) || input.contains(String.valueOf('\'')) || input.contains(" "))) {
            return input;
        }
        char first2 = input.charAt(0);
        char last2 = input.charAt(input.length() - 1);
        boolean bl = quote = input.length() >= 2 && first2 == last2 && (first2 == '\"' || first2 == '\'');
        if (!quote) {
            throw new ArgumentSyntaxException("String argument needs to start and end with quotes", input, 1);
        }
        input = input.substring(1, input.length() - 1);
        for (int i = 1; i < input.length(); ++i) {
            char lastChar;
            char c = input.charAt(i);
            if (c != first2 || (lastChar = input.charAt(i - 1)) == '\\') continue;
            throw new ArgumentSyntaxException("Non-escaped quote", input, 1);
        }
        return StringUtils.unescapeJavaString(input);
    }

    public String toString() {
        return String.format("String<%s>", this.getId());
    }
}

