/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import org.jetbrains.annotations.NotNull;

public class ArgumentLoop<T>
extends Argument<List<T>> {
    public static final int INVALID_INPUT_ERROR = 1;
    private final List<Argument<T>> arguments = new ArrayList<Argument<T>>();

    @SafeVarargs
    public ArgumentLoop(@NotNull String id2, Argument<T> ... arguments2) {
        super(id2, true, true);
        this.arguments.addAll(Arrays.asList(arguments2));
    }

    @Override
    @NotNull
    public List<T> parse(@NotNull String input) throws ArgumentSyntaxException {
        ArrayList<T> result2 = new ArrayList<T>();
        String[] split = input.split(" ");
        StringBuilder builder = new StringBuilder();
        boolean success = false;
        for (String s2 : split) {
            builder.append(s2);
            for (Argument<T> argument : this.arguments) {
                try {
                    String inputString = builder.toString();
                    T value = argument.parse(inputString);
                    success = true;
                    result2.add(value);
                    break;
                }
                catch (ArgumentSyntaxException ignored) {
                    success = false;
                }
            }
            if (success) {
                builder.setLength(0);
                continue;
            }
            builder.append(" ");
        }
        if (result2.isEmpty() || !success) {
            throw new ArgumentSyntaxException("Invalid loop, there is no valid argument found", input, 1);
        }
        return result2;
    }

    public List<Argument<T>> arguments() {
        return this.arguments;
    }

    @Override
    public String parser() {
        return null;
    }
}

