/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import net.minestom.server.command.builder.CommandExecutor;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.condition.CommandCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandSyntax {
    private CommandCondition commandCondition;
    private CommandExecutor executor;
    private final Map<String, Supplier<Object>> defaultValuesMap;
    private final Argument<?>[] args;
    private final boolean suggestion;

    protected CommandSyntax(@Nullable CommandCondition commandCondition, @NotNull CommandExecutor commandExecutor, @Nullable Map<String, Supplier<Object>> defaultValuesMap, Argument<?> ... args2) {
        this.commandCondition = commandCondition;
        this.executor = commandExecutor;
        this.defaultValuesMap = defaultValuesMap;
        this.args = args2;
        this.suggestion = Arrays.stream(args2).anyMatch(Argument::hasSuggestion);
    }

    protected CommandSyntax(@Nullable CommandCondition commandCondition, @NotNull CommandExecutor commandExecutor, Argument<?> ... args2) {
        this(commandCondition, commandExecutor, (Map<String, Supplier<Object>>)null, args2);
    }

    @Nullable
    public CommandCondition getCommandCondition() {
        return this.commandCondition;
    }

    public void setCommandCondition(@Nullable CommandCondition commandCondition) {
        this.commandCondition = commandCondition;
    }

    @NotNull
    public CommandExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(@NotNull CommandExecutor executor) {
        this.executor = executor;
    }

    @Nullable
    protected Map<String, Supplier<Object>> getDefaultValuesMap() {
        return this.defaultValuesMap;
    }

    @NotNull
    public Argument<?>[] getArguments() {
        return this.args;
    }

    public boolean hasSuggestion() {
        return this.suggestion;
    }

    @NotNull
    public String getSyntaxString() {
        StringBuilder builder = new StringBuilder();
        for (Argument<?> argument : this.args) {
            builder.append(argument.toString()).append(" ");
        }
        return builder.toString().trim();
    }
}

