/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.ArgumentCallback;
import net.minestom.server.command.builder.CommandContext;
import net.minestom.server.command.builder.CommandExecutor;
import net.minestom.server.command.builder.CommandSyntax;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.arguments.ArgumentLiteral;
import net.minestom.server.command.builder.arguments.ArgumentType;
import net.minestom.server.command.builder.arguments.ArgumentWord;
import net.minestom.server.command.builder.condition.CommandCondition;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command {
    public static final Logger LOGGER = LoggerFactory.getLogger(Command.class);
    private final String name;
    private final String[] aliases;
    private final String[] names;
    private CommandExecutor defaultExecutor;
    private CommandCondition condition;
    private final List<Command> subcommands;
    private final List<CommandSyntax> syntaxes;

    public Command(@NotNull String name2, String ... aliases) {
        this.name = name2;
        this.aliases = aliases;
        this.names = (String[])Stream.concat(Arrays.stream(aliases), Stream.of(name2)).toArray(String[]::new);
        this.subcommands = new ArrayList<Command>();
        this.syntaxes = new ArrayList<CommandSyntax>();
    }

    public Command(@NotNull String name2) {
        this(name2, new String[0]);
    }

    @Nullable
    public CommandCondition getCondition() {
        return this.condition;
    }

    public void setCondition(@Nullable CommandCondition commandCondition) {
        this.condition = commandCondition;
    }

    public void setArgumentCallback(@NotNull ArgumentCallback callback, @NotNull Argument<?> argument) {
        argument.setCallback(callback);
    }

    public void addSubcommand(@NotNull Command command2) {
        this.subcommands.add(command2);
    }

    @NotNull
    public List<Command> getSubcommands() {
        return Collections.unmodifiableList(this.subcommands);
    }

    @NotNull
    public Collection<CommandSyntax> addConditionalSyntax(@Nullable CommandCondition commandCondition, @NotNull CommandExecutor executor, Argument<?> ... args2) {
        boolean hasOptional = false;
        for (Argument<?> argument : args2) {
            if (argument.isOptional()) {
                hasOptional = true;
            }
            if (!hasOptional || argument.isOptional()) continue;
            LOGGER.warn("Optional arguments are followed by a non-optional one, the default values will be ignored.");
            hasOptional = false;
            break;
        }
        if (!hasOptional) {
            CommandSyntax syntax = new CommandSyntax(commandCondition, executor, args2);
            this.syntaxes.add(syntax);
            return List.of(syntax);
        }
        ArrayList<CommandSyntax> optionalSyntaxes = new ArrayList<CommandSyntax>();
        ArrayList requiredArguments = new ArrayList();
        HashMap<String, Supplier<Object>> defaultValuesMap = new HashMap<String, Supplier<Object>>();
        boolean optionalBranch = false;
        int i = 0;
        for (Argument<?> argument : args2) {
            CommandSyntax syntax;
            boolean isLast;
            boolean bl = isLast = ++i == args2.length;
            if (argument.isOptional()) {
                defaultValuesMap.put(argument.getId(), argument.getDefaultValue());
                if (!optionalBranch && !requiredArguments.isEmpty()) {
                    syntax = new CommandSyntax(commandCondition, executor, defaultValuesMap, requiredArguments.toArray(new Argument[0]));
                    optionalSyntaxes.add(syntax);
                    optionalBranch = true;
                } else {
                    syntax = new CommandSyntax(commandCondition, executor, defaultValuesMap, requiredArguments.toArray(new Argument[0]));
                    optionalSyntaxes.add(syntax);
                }
            }
            requiredArguments.add(argument);
            if (!isLast) continue;
            syntax = new CommandSyntax(commandCondition, executor, defaultValuesMap, requiredArguments.toArray(new Argument[0]));
            optionalSyntaxes.add(syntax);
        }
        this.syntaxes.addAll(optionalSyntaxes);
        return optionalSyntaxes;
    }

    @NotNull
    public Collection<CommandSyntax> addSyntax(@NotNull CommandExecutor executor, Argument<?> ... args2) {
        return this.addConditionalSyntax(null, executor, args2);
    }

    @ApiStatus.Experimental
    @NotNull
    public Collection<CommandSyntax> addSyntax(@NotNull CommandExecutor executor, @NotNull String format) {
        return this.addSyntax(executor, ArgumentType.generate(format));
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String[] getAliases() {
        return this.aliases;
    }

    @NotNull
    public String[] getNames() {
        return this.names;
    }

    @Nullable
    public CommandExecutor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public void setDefaultExecutor(@Nullable CommandExecutor executor) {
        this.defaultExecutor = executor;
    }

    @NotNull
    public Collection<CommandSyntax> getSyntaxes() {
        return this.syntaxes;
    }

    public void globalListener(@NotNull CommandSender sender, @NotNull CommandContext context, @NotNull String command2) {
    }

    @ApiStatus.Experimental
    @NotNull
    public Set<String> getSyntaxesStrings() {
        HashSet<String> syntaxes = new HashSet<String>();
        Consumer<String> syntaxConsumer = syntaxString -> {
            for (String name2 : this.getNames()) {
                String syntax = name2 + " " + syntaxString;
                syntaxes.add(syntax);
            }
        };
        this.subcommands.forEach(subcommand -> subcommand.getSyntaxesStrings().forEach(syntaxConsumer));
        this.syntaxes.forEach(commandSyntax -> syntaxConsumer.accept(commandSyntax.getSyntaxString()));
        return syntaxes;
    }

    @ApiStatus.Experimental
    @NotNull
    public String getSyntaxesTree() {
        Node commandNode = new Node();
        commandNode.names.addAll(Arrays.asList(this.getNames()));
        BiFunction<Node, Set, Node> findNode = (currentNode, literals) -> {
            for (Node node : currentNode.nodes) {
                Set<String> names = node.names;
                boolean shared = names.stream().anyMatch(literals::contains);
                if (!shared) continue;
                names.addAll((Collection<String>)literals);
                return node;
            }
            Node node = new Node();
            node.names.addAll((Collection<String>)literals);
            currentNode.nodes.add(node);
            return node;
        };
        BiConsumer<CommandSyntax, Node> syntaxProcessor = (syntax, node) -> {
            ArrayList<String> arguments2 = new ArrayList<String>();
            BiConsumer<Node, List> addArguments = (n, args2) -> {
                if (!args2.isEmpty()) {
                    n.arguments.add((List<String>)args2);
                }
            };
            boolean branched = false;
            for (Argument<?> argument : syntax.getArguments()) {
                if (!branched) {
                    ArgumentWord argumentWord;
                    if (argument instanceof ArgumentLiteral) {
                        String literal = argument.getId();
                        addArguments.accept((Node)node, arguments2);
                        arguments2 = new ArrayList();
                        node = (Node)findNode.apply((Node)node, Set.of(literal));
                        continue;
                    }
                    if (argument instanceof ArgumentWord && (argumentWord = (ArgumentWord)argument).hasRestrictions()) {
                        addArguments.accept((Node)node, arguments2);
                        arguments2 = new ArrayList();
                        node = (Node)findNode.apply((Node)node, Set.of(argumentWord.getRestrictions()));
                        continue;
                    }
                }
                branched = true;
                arguments2.add(argument.toString());
            }
            addArguments.accept((Node)node, arguments2);
        };
        this.subcommands.forEach(command2 -> {
            Node node = (Node)findNode.apply(commandNode, Set.of(command2.getNames()));
            command2.getSyntaxes().forEach(syntax -> syntaxProcessor.accept((CommandSyntax)syntax, node));
        });
        this.syntaxes.forEach(syntax -> syntaxProcessor.accept((CommandSyntax)syntax, commandNode));
        JsonObject jsonObject = new JsonObject();
        this.processNode(commandNode, jsonObject);
        return jsonObject.toString();
    }

    public static boolean isValidName(@NotNull Command command2, @NotNull String name2) {
        for (String commandName : command2.getNames()) {
            if (!commandName.equals(name2)) continue;
            return true;
        }
        return false;
    }

    private void processNode(@NotNull Node node, @NotNull JsonObject jsonObject) {
        BiConsumer<String, Consumer> processor = (s2, consumer) -> {
            JsonArray array = new JsonArray();
            consumer.accept(array);
            if (array.size() != 0) {
                jsonObject.add((String)s2, array);
            }
        };
        processor.accept("names", array -> node.names.forEach(array::add));
        processor.accept("nodes", array -> node.nodes.forEach(n -> {
            JsonObject nodeObject = new JsonObject();
            this.processNode((Node)n, nodeObject);
            array.add(nodeObject);
        }));
        processor.accept("arguments", array -> node.arguments.forEach(arguments2 -> array.add(String.join((CharSequence)" ", arguments2))));
    }

    private static final class Node {
        private final Set<String> names = new HashSet<String>();
        private final Set<Node> nodes = new HashSet<Node>();
        private final List<List<String>> arguments = new ArrayList<List<String>>();

        private Node() {
        }
    }
}

