/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minestom.server.command.CommandParser;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.ExecutableCommand;
import net.minestom.server.command.Graph;
import net.minestom.server.command.builder.ArgumentCallback;
import net.minestom.server.command.builder.CommandContext;
import net.minestom.server.command.builder.CommandData;
import net.minestom.server.command.builder.CommandExecutor;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.condition.CommandCondition;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.command.builder.suggestion.Suggestion;
import net.minestom.server.command.builder.suggestion.SuggestionCallback;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommandParserImpl
implements CommandParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandParserImpl.class);
    static final CommandParserImpl PARSER = new CommandParserImpl();

    CommandParserImpl() {
    }

    @Override
    @NotNull
    public CommandParser.Result parse(@NotNull Graph graph, @NotNull String input) {
        NodeResult result2;
        CommandStringReader reader = new CommandStringReader(input);
        Chain chain = new Chain();
        Graph.Node parent = graph.root();
        while ((result2 = CommandParserImpl.parseChild(parent, reader)) != null) {
            chain.append(result2);
            ArgumentResult<Object> argumentResult = result2.argumentResult;
            if (argumentResult instanceof ArgumentResult.SyntaxError) {
                ArgumentResult.SyntaxError e = (ArgumentResult.SyntaxError)argumentResult;
                ArgumentCallback argumentCallback = parent.argument().getCallback();
                if (argumentCallback == null && chain.defaultExecutor != null) {
                    return ValidCommand.defaultExecutor(input, chain);
                }
                return new InvalidCommand(input, chain.mergedConditions(), argumentCallback, e, chain.collectArguments(), chain.mergedGlobalExecutors(), chain.extractSuggestionCallback(), chain.getArgs());
            }
            parent = result2.node;
        }
        block1: do {
            Graph.Node tmp = parent;
            parent = null;
            for (Graph.Node child : tmp.next()) {
                Argument<?> argument = child.argument();
                Supplier<?> defaultSupplier = argument.getDefaultValue();
                if (defaultSupplier == null) continue;
                Object value = defaultSupplier.get();
                ArgumentResult.Success<Object> argumentResult = new ArgumentResult.Success<Object>(value, "");
                chain.append(new NodeResult(child, argumentResult, argument.getSuggestionCallback()));
                parent = child;
                continue block1;
            }
        } while (parent != null);
        NodeResult lastNode = chain.nodeResults.peekLast();
        if (lastNode == null) {
            return UnknownCommandResult.INSTANCE;
        }
        CommandExecutor executor = CommandParserImpl.nullSafeGetter(lastNode.node().execution(), Graph.Execution::executor);
        if (executor == null) {
            if (chain.defaultExecutor != null) {
                return ValidCommand.defaultExecutor(input, chain);
            }
            return InvalidCommand.invalid(input, chain);
        }
        if (reader.hasRemaining()) {
            if (chain.defaultExecutor != null) {
                return ValidCommand.defaultExecutor(input, chain);
            }
            return InvalidCommand.invalid(input, chain);
        }
        return ValidCommand.executor(input, chain, executor);
    }

    @Contract(value="null, _ -> null; !null, null -> fail; !null, !null -> _")
    @Nullable
    private static <R, T> R nullSafeGetter(@Nullable T obj, Function<T, R> getter) {
        return obj == null ? null : (R)getter.apply(obj);
    }

    private static NodeResult parseChild(Graph.Node parent, CommandStringReader reader) {
        if (!reader.hasRemaining()) {
            return null;
        }
        for (Graph.Node child : parent.next()) {
            Argument<?> argument = child.argument();
            int start = reader.cursor();
            ArgumentResult<?> parse = CommandParserImpl.parse(argument, reader);
            if (parse instanceof ArgumentResult.Success) {
                ArgumentResult.Success success = (ArgumentResult.Success)parse;
                return new NodeResult(child, success, argument.getSuggestionCallback());
            }
            if (parse instanceof ArgumentResult.SyntaxError) {
                ArgumentResult.SyntaxError syntaxError = (ArgumentResult.SyntaxError)parse;
                return new NodeResult(child, syntaxError, argument.getSuggestionCallback());
            }
            reader.cursor(start);
        }
        for (Graph.Node node : parent.next()) {
            SuggestionCallback suggestionCallback = node.argument().getSuggestionCallback();
            if (suggestionCallback == null) continue;
            return new NodeResult(parent, new ArgumentResult.SyntaxError<Object>("None of the arguments were compatible, but a suggestion callback was found.", "", -1), suggestionCallback);
        }
        return null;
    }

    private static CommandContext createCommandContext(String input, Map<String, ArgumentResult<Object>> arguments2) {
        CommandContext context = new CommandContext(input);
        for (Map.Entry<String, ArgumentResult<Object>> entry2 : arguments2.entrySet()) {
            String string;
            Object argOutput;
            String identifier = entry2.getKey();
            ArgumentResult<Object> value = entry2.getValue();
            if (value instanceof ArgumentResult.Success) {
                ArgumentResult.Success success = (ArgumentResult.Success)value;
                v0 = success.value();
            } else {
                v0 = argOutput = null;
            }
            if (value instanceof ArgumentResult.Success) {
                ArgumentResult.Success success = (ArgumentResult.Success)value;
                string = success.input();
            } else {
                string = "";
            }
            String argInput = string;
            context.setArg(identifier, argOutput, argInput);
        }
        return context;
    }

    private static <T> ArgumentResult<T> parse(Argument<T> argument, CommandStringReader reader) {
        try {
            if (!argument.allowSpace()) {
                String word = reader.readWord();
                return new ArgumentResult.Success<T>(argument.parse(word), word);
            }
            if (argument.useRemaining()) {
                String remaining = reader.readRemaining();
                return new ArgumentResult.Success<T>(argument.parse(remaining), remaining);
            }
        }
        catch (ArgumentSyntaxException ignored) {
            return new ArgumentResult.IncompatibleType();
        }
        assert (argument.allowSpace() && !argument.useRemaining());
        StringBuilder current = new StringBuilder(reader.readWord());
        while (true) {
            try {
                String input = current.toString();
                return new ArgumentResult.Success<T>(argument.parse(input), input);
            }
            catch (ArgumentSyntaxException ignored) {
                if (reader.hasRemaining()) {
                    current.append(" ");
                    current.append(reader.readWord());
                    continue;
                }
                return new ArgumentResult.IncompatibleType();
            }
            break;
        }
    }

    static final class CommandStringReader {
        private final String input;
        private int cursor = 0;

        CommandStringReader(String input) {
            this.input = input;
        }

        boolean hasRemaining() {
            return this.cursor < this.input.length();
        }

        String readWord() {
            String input = this.input;
            int cursor = this.cursor;
            int i = input.indexOf(32, cursor);
            if (i == -1) {
                this.cursor = input.length() + 1;
                return input.substring(cursor);
            }
            String read = input.substring(cursor, i);
            this.cursor += read.length() + 1;
            return read;
        }

        String readRemaining() {
            String input = this.input;
            String result2 = input.substring(this.cursor);
            this.cursor = input.length();
            return result2;
        }

        int cursor() {
            return this.cursor;
        }

        void cursor(int cursor) {
            assert (cursor >= 0 && cursor <= this.input.length());
            this.cursor = cursor;
        }
    }

    static final class Chain {
        CommandExecutor defaultExecutor = null;
        final ArrayDeque<NodeResult> nodeResults = new ArrayDeque();
        final List<CommandCondition> conditions = new ArrayList<CommandCondition>();
        final List<CommandExecutor> globalListeners = new ArrayList<CommandExecutor>();

        Chain() {
        }

        void append(NodeResult result2) {
            this.nodeResults.add(result2);
            Graph.Execution execution = result2.node.execution();
            if (execution != null) {
                CommandExecutor globalListener;
                CommandExecutor defExec;
                CommandCondition condition = execution.condition();
                if (condition != null) {
                    this.conditions.add(condition);
                }
                if ((defExec = execution.defaultExecutor()) != null) {
                    this.defaultExecutor = defExec;
                }
                if ((globalListener = execution.globalListener()) != null) {
                    this.globalListeners.add(globalListener);
                }
            }
        }

        CommandCondition mergedConditions() {
            return (sender, commandString) -> {
                for (CommandCondition condition : this.conditions) {
                    if (condition.canUse(sender, commandString)) continue;
                    return false;
                }
                return true;
            };
        }

        CommandExecutor mergedGlobalExecutors() {
            return (sender, context) -> this.globalListeners.forEach(x -> x.apply(sender, context));
        }

        SuggestionCallback extractSuggestionCallback() {
            return this.nodeResults.peekLast().callback;
        }

        Map<String, ArgumentResult<Object>> collectArguments() {
            return this.nodeResults.stream().skip(1L).collect(Collectors.toUnmodifiableMap(NodeResult::name, NodeResult::argumentResult));
        }

        List<Argument<?>> getArgs() {
            return this.nodeResults.stream().map(x -> x.node.argument()).collect(Collectors.toList());
        }
    }

    private record NodeResult(Graph.Node node, ArgumentResult<Object> argumentResult, SuggestionCallback callback) {
        public String name() {
            return this.node.argument().getId();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface ArgumentResult<R> {

        public record SyntaxError<T>(String message, String input, int code) implements ArgumentResult<T>
        {
        }

        public record IncompatibleType<T>() implements ArgumentResult<T>
        {
        }

        public record Success<T>(T value, String input) implements ArgumentResult<T>
        {
        }
    }

    record ValidCommand(String input, CommandCondition condition, CommandExecutor executor, @NotNull Map<String, ArgumentResult<Object>> arguments, CommandExecutor globalListener, @Nullable SuggestionCallback suggestionCallback, List<Argument<?>> args) implements InternalKnownCommand,
    CommandParser.Result.KnownCommand.Valid
    {
        static ValidCommand defaultExecutor(String input, Chain chain) {
            return new ValidCommand(input, chain.mergedConditions(), chain.defaultExecutor, chain.collectArguments(), chain.mergedGlobalExecutors(), chain.extractSuggestionCallback(), chain.getArgs());
        }

        static ValidCommand executor(String input, Chain chain, CommandExecutor executor) {
            return new ValidCommand(input, chain.mergedConditions(), executor, chain.collectArguments(), chain.mergedGlobalExecutors(), chain.extractSuggestionCallback(), chain.getArgs());
        }

        @Override
        @NotNull
        public ExecutableCommand executable() {
            return new ValidExecutableCmd(this.condition, this.globalListener, this.executor, this.input, this.arguments);
        }
    }

    record InvalidCommand(String input, CommandCondition condition, ArgumentCallback callback, ArgumentResult.SyntaxError<?> error, @NotNull Map<String, ArgumentResult<Object>> arguments, CommandExecutor globalListener, @Nullable SuggestionCallback suggestionCallback, List<Argument<?>> args) implements InternalKnownCommand,
    CommandParser.Result.KnownCommand.Invalid
    {
        static InvalidCommand invalid(String input, Chain chain) {
            return new InvalidCommand(input, chain.mergedConditions(), null, new ArgumentResult.SyntaxError("Command has trailing data.", null, -1), chain.collectArguments(), chain.mergedGlobalExecutors(), chain.extractSuggestionCallback(), chain.getArgs());
        }

        @Override
        @NotNull
        public ExecutableCommand executable() {
            return new InvalidExecutableCmd(this.condition, this.globalListener, this.callback, this.error, this.input, this.arguments);
        }
    }

    record UnknownCommandResult() implements CommandParser.Result.UnknownCommand
    {
        private static final CommandParser.Result INSTANCE = new UnknownCommandResult();

        @Override
        @NotNull
        public ExecutableCommand executable() {
            return UnknownExecutableCmd.INSTANCE;
        }

        @Override
        @Nullable
        public Suggestion suggestion(CommandSender sender) {
            return null;
        }

        @Override
        public List<Argument<?>> args() {
            return null;
        }
    }

    record ExecutionResultImpl(ExecutableCommand.Result.Type type, CommandData commandData) implements ExecutableCommand.Result
    {
        static final ExecutableCommand.Result CANCELLED = new ExecutionResultImpl(ExecutableCommand.Result.Type.CANCELLED, null);
        static final ExecutableCommand.Result UNKNOWN = new ExecutionResultImpl(ExecutableCommand.Result.Type.UNKNOWN, null);
        static final ExecutableCommand.Result EXECUTOR_EXCEPTION = new ExecutionResultImpl(ExecutableCommand.Result.Type.EXECUTOR_EXCEPTION, null);
        static final ExecutableCommand.Result PRECONDITION_FAILED = new ExecutionResultImpl(ExecutableCommand.Result.Type.PRECONDITION_FAILED, null);
        static final ExecutableCommand.Result INVALID_SYNTAX = new ExecutionResultImpl(ExecutableCommand.Result.Type.INVALID_SYNTAX, null);
    }

    record InvalidExecutableCmd(CommandCondition condition, CommandExecutor globalListener, ArgumentCallback callback, ArgumentResult.SyntaxError<?> error, String input, Map<String, ArgumentResult<Object>> arguments) implements ExecutableCommand
    {
        @Override
        @NotNull
        public ExecutableCommand.Result execute(@NotNull CommandSender sender) {
            this.globalListener().apply(sender, CommandParserImpl.createCommandContext(this.input, this.arguments));
            if (this.condition != null && !this.condition.canUse(sender, this.input())) {
                return ExecutionResultImpl.PRECONDITION_FAILED;
            }
            if (this.callback != null) {
                this.callback.apply(sender, new ArgumentSyntaxException(this.error.message(), this.error.input(), this.error.code()));
            }
            return ExecutionResultImpl.INVALID_SYNTAX;
        }
    }

    record ValidExecutableCmd(CommandCondition condition, CommandExecutor globalListener, CommandExecutor executor, String input, Map<String, ArgumentResult<Object>> arguments) implements ExecutableCommand
    {
        @Override
        @NotNull
        public ExecutableCommand.Result execute(@NotNull CommandSender sender) {
            CommandContext context = CommandParserImpl.createCommandContext(this.input, this.arguments);
            this.globalListener().apply(sender, context);
            if (this.condition != null && !this.condition.canUse(sender, this.input())) {
                return ExecutionResultImpl.PRECONDITION_FAILED;
            }
            try {
                this.executor().apply(sender, context);
                return new ExecutionResultImpl(ExecutableCommand.Result.Type.SUCCESS, context.getReturnData());
            }
            catch (Exception e) {
                LOGGER.error("An exception was encountered while executing command: " + this.input(), e);
                return ExecutionResultImpl.EXECUTOR_EXCEPTION;
            }
        }
    }

    record UnknownExecutableCmd() implements ExecutableCommand
    {
        static final ExecutableCommand INSTANCE = new UnknownExecutableCmd();

        @Override
        @NotNull
        public ExecutableCommand.Result execute(@NotNull CommandSender sender) {
            return ExecutionResultImpl.UNKNOWN;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface InternalKnownCommand
    extends CommandParser.Result.KnownCommand {
        public String input();

        @Nullable
        public CommandCondition condition();

        @NotNull
        public Map<String, ArgumentResult<Object>> arguments();

        public CommandExecutor globalListener();

        @Nullable
        public SuggestionCallback suggestionCallback();

        @Override
        @Nullable
        default public Suggestion suggestion(CommandSender sender) {
            SuggestionCallback callback = this.suggestionCallback();
            if (callback == null) {
                return null;
            }
            int lastSpace = this.input().lastIndexOf(" ");
            Suggestion suggestion = new Suggestion(this.input(), lastSpace + 2, this.input().length() - lastSpace - 1);
            CommandContext context = CommandParserImpl.createCommandContext(this.input(), this.arguments());
            callback.apply(sender, context, suggestion);
            return suggestion;
        }
    }
}

