/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.util.List;
import net.minestom.server.command.CommandParserImpl;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.ExecutableCommand;
import net.minestom.server.command.Graph;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.suggestion.Suggestion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@ApiStatus.Experimental
public interface CommandParser {
    @NotNull
    public static CommandParser parser() {
        return CommandParserImpl.PARSER;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public Result parse(@NotNull Graph var1, @NotNull String var2);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Result {
        @NotNull
        public ExecutableCommand executable();

        @ApiStatus.Internal
        @Nullable
        public Suggestion suggestion(CommandSender var1);

        @ApiStatus.Internal
        public List<Argument<?>> args();

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static interface KnownCommand
        extends Result {

            /*
             * Uses 'sealed' constructs - enablewith --sealed true
             */
            public static interface Invalid
            extends KnownCommand {
            }

            /*
             * Uses 'sealed' constructs - enablewith --sealed true
             */
            public static interface Valid
            extends KnownCommand {
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static interface UnknownCommand
        extends Result {
        }
    }
}

