/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.RayUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.registry.Registry;
import org.jetbrains.annotations.NotNull;

final class ShapeImpl
implements Shape {
    private static final Pattern PATTERN = Pattern.compile("\\d.\\d{1,3}", 8);
    private final BoundingBox[] blockSections;
    private final Point relativeStart;
    private final Point relativeEnd;
    private final Registry.BlockEntry blockEntry;
    private Block block;

    private ShapeImpl(BoundingBox[] boundingBoxes, Registry.BlockEntry blockEntry) {
        this.blockSections = boundingBoxes;
        this.blockEntry = blockEntry;
        double minX = 1.0;
        double minY = 1.0;
        double minZ = 1.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (BoundingBox blockSection : this.blockSections) {
            if (blockSection.minX() < minX) {
                minX = blockSection.minX();
            }
            if (blockSection.minY() < minY) {
                minY = blockSection.minY();
            }
            if (blockSection.minZ() < minZ) {
                minZ = blockSection.minZ();
            }
            if (blockSection.maxX() > maxX) {
                maxX = blockSection.maxX();
            }
            if (blockSection.maxY() > maxY) {
                maxY = blockSection.maxY();
            }
            if (!(blockSection.maxZ() > maxZ)) continue;
            maxZ = blockSection.maxZ();
        }
        this.relativeStart = new Vec(minX, minY, minZ);
        this.relativeEnd = new Vec(maxX, maxY, maxZ);
    }

    static ShapeImpl parseBlockFromRegistry(String str, Registry.BlockEntry blockEntry) {
        Matcher matcher = PATTERN.matcher(str);
        DoubleArrayList vals = new DoubleArrayList();
        while (matcher.find()) {
            double newVal = Double.parseDouble(matcher.group());
            vals.add(newVal);
        }
        int count2 = vals.size() / 6;
        BoundingBox[] boundingBoxes = new BoundingBox[count2];
        for (int i = 0; i < count2; ++i) {
            double minX = vals.getDouble(0 + 6 * i);
            double minY = vals.getDouble(1 + 6 * i);
            double minZ = vals.getDouble(2 + 6 * i);
            double boundXSize = vals.getDouble(3 + 6 * i) - minX;
            double boundYSize = vals.getDouble(4 + 6 * i) - minY;
            double boundZSize = vals.getDouble(5 + 6 * i) - minZ;
            BoundingBox bb = new BoundingBox(boundXSize, boundYSize, boundZSize, new Vec(minX, minY, minZ));
            assert (bb.minX() == minX);
            assert (bb.minY() == minY);
            assert (bb.minZ() == minZ);
            boundingBoxes[i] = bb;
        }
        return new ShapeImpl(boundingBoxes, blockEntry);
    }

    @Override
    @NotNull
    public Point relativeStart() {
        return this.relativeStart;
    }

    @Override
    @NotNull
    public Point relativeEnd() {
        return this.relativeEnd;
    }

    @Override
    public boolean intersectBox(@NotNull Point position, @NotNull BoundingBox boundingBox) {
        for (BoundingBox blockSection : this.blockSections) {
            if (!boundingBox.intersectBox(position, blockSection)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectBoxSwept(@NotNull Point rayStart, @NotNull Point rayDirection, @NotNull Point shapePos, @NotNull BoundingBox moving, @NotNull SweepResult finalResult) {
        boolean hitBlock = false;
        for (BoundingBox blockSection : this.blockSections) {
            if (RayUtils.BoundingBoxIntersectionCheck(moving, rayStart, rayDirection, blockSection, shapePos, finalResult)) {
                finalResult.collidedShapePosition = shapePos;
                finalResult.collidedShape = this;
                finalResult.blockType = this.block();
            }
            hitBlock = true;
        }
        return hitBlock;
    }

    private Block block() {
        Block block = this.block;
        if (block == null) {
            this.block = block = Block.fromStateId((short)this.blockEntry.stateId());
        }
        return block;
    }
}

