/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import net.minestom.server.collision.BlockCollision;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.ShapeImpl;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.WorldBorder;
import net.minestom.server.instance.block.Block;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.chunk.ChunkCache;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class CollisionUtils {
    public static PhysicsResult handlePhysics(@NotNull Entity entity, @NotNull Vec entityVelocity, @Nullable PhysicsResult lastPhysicsResult) {
        Instance instance = entity.getInstance();
        assert (instance != null);
        return CollisionUtils.handlePhysics(instance, entity.getChunk(), entity.getBoundingBox(), entity.getPosition(), entityVelocity, lastPhysicsResult);
    }

    public static PhysicsResult handlePhysics(@NotNull Instance instance, @Nullable Chunk chunk, @NotNull BoundingBox boundingBox, @NotNull Pos position, @NotNull Vec velocity, @Nullable PhysicsResult lastPhysicsResult) {
        ChunkCache getter = new ChunkCache(instance, chunk != null ? chunk : instance.getChunkAt(position), Block.STONE);
        return BlockCollision.handlePhysics(boundingBox, velocity, position, getter, lastPhysicsResult);
    }

    public static boolean isLineOfSightReachingShape(@NotNull Instance instance, @Nullable Chunk chunk, @NotNull Point start, @NotNull Point end, @NotNull Shape shape) {
        PhysicsResult result2 = CollisionUtils.handlePhysics(instance, chunk, BoundingBox.ZERO, Pos.fromPoint(start), Vec.fromPoint(end.sub(start)), null);
        return shape.intersectBox(end.sub(result2.newPosition()).sub(1.0E-6), BoundingBox.ZERO);
    }

    public static PhysicsResult handlePhysics(@NotNull Entity entity, @NotNull Vec entityVelocity) {
        return CollisionUtils.handlePhysics(entity, entityVelocity, null);
    }

    public static Entity canPlaceBlockAt(Instance instance, Point blockPos, Block b) {
        return BlockCollision.canPlaceBlockAt(instance, blockPos, b);
    }

    @NotNull
    public static Pos applyWorldBorder(@NotNull Instance instance, @NotNull Pos currentPosition, @NotNull Pos newPosition) {
        WorldBorder worldBorder = instance.getWorldBorder();
        WorldBorder.CollisionAxis collisionAxis = worldBorder.getCollisionAxis(newPosition);
        return switch (collisionAxis) {
            default -> throw new IncompatibleClassChangeError();
            case WorldBorder.CollisionAxis.NONE -> newPosition;
            case WorldBorder.CollisionAxis.BOTH -> new Pos(currentPosition.x(), newPosition.y(), currentPosition.z());
            case WorldBorder.CollisionAxis.X -> new Pos(currentPosition.x(), newPosition.y(), newPosition.z());
            case WorldBorder.CollisionAxis.Z -> new Pos(newPosition.x(), newPosition.y(), currentPosition.z());
        };
    }

    public static Shape parseBlockShape(String str, Registry.BlockEntry blockEntry) {
        return ShapeImpl.parseBlockFromRegistry(str, blockEntry);
    }
}

