/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import net.minestom.server.collision.RayUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BoundingBox
implements Shape {
    private static final BoundingBox sleepingBoundingBox = new BoundingBox(0.2, 0.2, 0.2);
    private static final BoundingBox sneakingBoundingBox = new BoundingBox(0.6, 1.5, 0.6);
    private static final BoundingBox smallBoundingBox = new BoundingBox(0.6, 0.6, 0.6);
    static final BoundingBox ZERO = new BoundingBox(0.0, 0.0, 0.0);
    private final double width;
    private final double height;
    private final double depth;
    private final Point offset;
    private Point relativeEnd;

    BoundingBox(double width, double height, double depth, Point offset) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.offset = offset;
    }

    public BoundingBox(double width, double height, double depth) {
        this(width, height, depth, new Vec(-width / 2.0, 0.0, -depth / 2.0));
    }

    @Override
    @ApiStatus.Experimental
    public boolean intersectBox(@NotNull Point positionRelative, @NotNull BoundingBox boundingBox) {
        return this.minX() + positionRelative.x() <= boundingBox.maxX() - 5.0E-7 && this.maxX() + positionRelative.x() >= boundingBox.minX() + 5.0E-7 && this.minY() + positionRelative.y() <= boundingBox.maxY() - 5.0E-7 && this.maxY() + positionRelative.y() >= boundingBox.minY() + 5.0E-7 && this.minZ() + positionRelative.z() <= boundingBox.maxZ() - 5.0E-7 && this.maxZ() + positionRelative.z() >= boundingBox.minZ() + 5.0E-7;
    }

    @Override
    @ApiStatus.Experimental
    public boolean intersectBoxSwept(@NotNull Point rayStart, @NotNull Point rayDirection, @NotNull Point shapePos, @NotNull BoundingBox moving, @NotNull SweepResult finalResult) {
        if (RayUtils.BoundingBoxIntersectionCheck(moving, rayStart, rayDirection, this, shapePos, finalResult)) {
            finalResult.collidedShapePosition = shapePos;
            finalResult.collidedShape = this;
            finalResult.blockType = null;
        }
        return true;
    }

    @ApiStatus.Experimental
    public boolean intersectEntity(@NotNull Point src, @NotNull Entity entity) {
        return this.intersectBox(src.sub(entity.getPosition()), entity.getBoundingBox());
    }

    @ApiStatus.Experimental
    public boolean boundingBoxRayIntersectionCheck(Vec start, Vec direction, Pos position) {
        return RayUtils.BoundingBoxRayIntersectionCheck(start, direction, this, position);
    }

    @Override
    @NotNull
    public Point relativeStart() {
        return this.offset;
    }

    @Override
    @NotNull
    public Point relativeEnd() {
        Point relativeEnd = this.relativeEnd;
        if (relativeEnd == null) {
            this.relativeEnd = relativeEnd = this.offset.add(this.width, this.height, this.depth);
        }
        return relativeEnd;
    }

    public String toString() {
        Object result2 = "BoundingBox";
        result2 = (String)result2 + "\n";
        result2 = (String)result2 + "[" + this.minX() + " : " + this.maxX() + "]";
        result2 = (String)result2 + "\n";
        result2 = (String)result2 + "[" + this.minY() + " : " + this.maxY() + "]";
        result2 = (String)result2 + "\n";
        result2 = (String)result2 + "[" + this.minZ() + " : " + this.maxZ() + "]";
        return result2;
    }

    @NotNull
    public BoundingBox expand(double x, double y, double z) {
        return new BoundingBox(this.width + x, this.height + y, this.depth + z);
    }

    @NotNull
    public BoundingBox contract(double x, double y, double z) {
        return new BoundingBox(this.width - x, this.height - y, this.depth - z);
    }

    public double width() {
        return this.width;
    }

    public double height() {
        return this.height;
    }

    public double depth() {
        return this.depth;
    }

    public double minX() {
        return this.relativeStart().x();
    }

    public double maxX() {
        return this.relativeEnd().x();
    }

    public double minY() {
        return this.relativeStart().y();
    }

    public double maxY() {
        return this.relativeEnd().y();
    }

    public double minZ() {
        return this.relativeStart().z();
    }

    public double maxZ() {
        return this.relativeEnd().z();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundingBox that = (BoundingBox)o;
        if (Double.compare(that.width, this.width) != 0) {
            return false;
        }
        if (Double.compare(that.height, this.height) != 0) {
            return false;
        }
        if (Double.compare(that.depth, this.depth) != 0) {
            return false;
        }
        return this.offset.equals(that.offset);
    }

    @Nullable
    public static BoundingBox fromPose(@NotNull Entity.Pose pose) {
        return switch (pose) {
            case Entity.Pose.FALL_FLYING, Entity.Pose.SWIMMING, Entity.Pose.SPIN_ATTACK -> smallBoundingBox;
            case Entity.Pose.SLEEPING, Entity.Pose.DYING -> sleepingBoundingBox;
            case Entity.Pose.SNEAKING -> sneakingBoundingBox;
            default -> null;
        };
    }
}

