/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.provider;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.util.Codec;
import net.minestom.server.adventure.MinestomAdventure;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTException;

final class NBTLegacyHoverEventSerializer
implements LegacyHoverEventSerializer {
    static final NBTLegacyHoverEventSerializer INSTANCE = new NBTLegacyHoverEventSerializer();
    private static final String ITEM_TYPE = "id";
    private static final String ITEM_COUNT = "Count";
    private static final String ITEM_TAG = "tag";
    private static final String ENTITY_TYPE = "type";
    private static final String ENTITY_NAME = "name";
    private static final String ENTITY_ID = "id";

    private NBTLegacyHoverEventSerializer() {
    }

    @Override
    public  @NotNull HoverEvent.ShowItem deserializeShowItem(@NotNull Component input) throws IOException {
        String raw = PlainTextComponentSerializer.plainText().serialize(input);
        try {
            NBT nbt = MinestomAdventure.NBT_CODEC.decode(raw);
            if (!(nbt instanceof NBTCompound)) {
                throw new IOException("contents were not a compound");
            }
            NBTCompound contents = (NBTCompound)nbt;
            NBTCompound tag = contents.getCompound(ITEM_TAG);
            return HoverEvent.ShowItem.of(Key.key(Objects.requireNonNullElse(contents.getString("id"), "")), (int)Objects.requireNonNullElse(contents.getByte(ITEM_COUNT), (byte)1).byteValue(), tag == null ? null : BinaryTagHolder.encode(tag, MinestomAdventure.NBT_CODEC));
        }
        catch (NBTException e) {
            throw new IOException(e);
        }
    }

    @Override
    public  @NotNull HoverEvent.ShowEntity deserializeShowEntity(@NotNull Component input, Codec.Decoder<Component, String, ? extends RuntimeException> componentDecoder) throws IOException {
        String raw = PlainTextComponentSerializer.plainText().serialize(input);
        try {
            NBT nbt = MinestomAdventure.NBT_CODEC.decode(raw);
            if (!(nbt instanceof NBTCompound)) {
                throw new IOException("contents were not a compound");
            }
            NBTCompound contents = (NBTCompound)nbt;
            return HoverEvent.ShowEntity.of(Key.key(Objects.requireNonNullElse(contents.getString(ENTITY_TYPE), "")), UUID.fromString(Objects.requireNonNullElse(contents.getString("id"), "")), componentDecoder.decode(Objects.requireNonNullElse(contents.getString(ENTITY_NAME), "")));
        }
        catch (NBTException e) {
            throw new IOException(e);
        }
    }

    @Override
    @NotNull
    public Component serializeShowItem( @NotNull HoverEvent.ShowItem input) throws IOException {
        AtomicReference<Object> exception = new AtomicReference<Object>(null);
        NBTCompound tag = NBT.Compound(t2 -> {
            t2.setString("id", input.item().asString());
            t2.setByte(ITEM_COUNT, (byte)input.count());
            BinaryTagHolder nbt = input.nbt();
            if (nbt != null) {
                try {
                    t2.set(ITEM_TAG, nbt.get(MinestomAdventure.NBT_CODEC));
                }
                catch (NBTException e) {
                    exception.set(e);
                }
            }
        });
        if (exception.get() != null) {
            throw new IOException(exception.get());
        }
        return Component.text(MinestomAdventure.NBT_CODEC.encode(tag));
    }

    @Override
    @NotNull
    public Component serializeShowEntity( @NotNull HoverEvent.ShowEntity input, Codec.Encoder<Component, String, ? extends RuntimeException> componentEncoder) {
        NBTCompound tag = NBT.Compound(t2 -> {
            t2.setString("id", input.id().toString());
            t2.setString(ENTITY_TYPE, input.type().asString());
            Component name2 = input.name();
            if (name2 != null) {
                t2.setString(ENTITY_NAME, (String)componentEncoder.encode(name2));
            }
        });
        return Component.text(MinestomAdventure.NBT_CODEC.encode(tag));
    }
}

