/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.audience;

import java.util.Collection;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.TitlePart;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Player;
import net.minestom.server.message.ChatPosition;
import net.minestom.server.message.Messenger;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.play.ActionBarPacket;
import net.minestom.server.network.packet.server.play.ClearTitlesPacket;
import net.minestom.server.network.packet.server.play.PlayerListHeaderAndFooterPacket;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public interface PacketGroupingAudience
extends ForwardingAudience {
    @NotNull
    public static PacketGroupingAudience of(@NotNull Collection<Player> players) {
        return () -> players;
    }

    @NotNull
    public @NotNull Collection<@NotNull Player> getPlayers();

    default public void sendGroupedPacket(@NotNull ServerPacket packet) {
        PacketUtils.sendGroupedPacket(this.getPlayers(), packet);
    }

    @Override
    default public void sendMessage(@NotNull Identity source, @NotNull Component message, @NotNull MessageType type2) {
        Messenger.sendMessage(this.getPlayers(), message, ChatPosition.fromMessageType(type2), source.uuid());
    }

    @Override
    default public void sendActionBar(@NotNull Component message) {
        this.sendGroupedPacket(new ActionBarPacket(message));
    }

    @Override
    default public void sendPlayerListHeaderAndFooter(@NotNull Component header, @NotNull Component footer) {
        this.sendGroupedPacket(new PlayerListHeaderAndFooterPacket(header, footer));
    }

    @Override
    default public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        this.sendGroupedPacket(AdventurePacketConvertor.createTitlePartPacket(part, value));
    }

    @Override
    default public void clearTitle() {
        this.sendGroupedPacket(new ClearTitlesPacket(false));
    }

    @Override
    default public void resetTitle() {
        this.sendGroupedPacket(new ClearTitlesPacket(true));
    }

    @Override
    default public void showBossBar(@NotNull BossBar bar) {
        MinecraftServer.getBossBarManager().addBossBar(this.getPlayers(), bar);
    }

    @Override
    default public void hideBossBar(@NotNull BossBar bar) {
        MinecraftServer.getBossBarManager().removeBossBar(this.getPlayers(), bar);
    }

    default public void playSound(@NotNull Sound sound, @NotNull Point point) {
        this.playSound(sound, point.x(), point.y(), point.z());
    }

    @Override
    default public void playSound(@NotNull Sound sound, double x, double y, double z) {
        this.sendGroupedPacket(AdventurePacketConvertor.createSoundPacket(sound, x, y, z));
    }

    @Override
    default public void playSound(@NotNull Sound sound, @NotNull Sound.Emitter emitter) {
        if (emitter != Sound.Emitter.self()) {
            this.sendGroupedPacket(AdventurePacketConvertor.createSoundPacket(sound, emitter));
        } else {
            for (Audience audience : this.audiences()) {
                audience.playSound(sound, emitter);
            }
        }
    }

    @Override
    default public void stopSound(@NotNull SoundStop stop) {
        this.sendGroupedPacket(AdventurePacketConvertor.createSoundStopPacket(stop));
    }

    @Override
    @NotNull
    default public Iterable<? extends Audience> audiences() {
        return this.getPlayers();
    }
}

