/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.audience;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import org.jetbrains.annotations.NotNull;

public class AudienceRegistry {
    private final Map<Key, Collection<Audience>> registry;
    private final Function<Key, Collection<Audience>> provider;

    public AudienceRegistry(@NotNull Map<Key, Collection<Audience>> backingMap, @NotNull Supplier<Collection<Audience>> backingCollection) {
        this.registry = backingMap;
        this.provider = key -> (Collection)backingCollection.get();
    }

    public boolean isEmpty() {
        return this.registry.isEmpty();
    }

    public void register(@NotNull Keyed keyed, Audience ... audiences) {
        this.register(keyed.key(), audiences);
    }

    public void register(@NotNull Keyed keyed, @NotNull Collection<Audience> audiences) {
        this.register(keyed.key(), audiences);
    }

    public void register(@NotNull Key key, Audience ... audiences) {
        if (audiences == null || audiences.length == 0) {
            return;
        }
        this.register(key, Arrays.asList(audiences));
    }

    public void register(@NotNull Key key, @NotNull Collection<Audience> audiences) {
        if (!audiences.isEmpty()) {
            this.registry.computeIfAbsent(key, this.provider).addAll(audiences);
        }
    }

    @NotNull
    public Iterable<? extends Audience> all() {
        if (this.isEmpty()) {
            return List.of();
        }
        return this.registry.values().stream().flatMap(Collection::stream).toList();
    }

    @NotNull
    public Iterable<? extends Audience> of(@NotNull Keyed keyed) {
        return this.of(keyed.key());
    }

    @NotNull
    public Iterable<? extends Audience> of(@NotNull Key key) {
        return Collections.unmodifiableCollection(this.registry.getOrDefault(key, this.provider.apply(null)));
    }

    @NotNull
    public Iterable<? extends Audience> of(@NotNull Predicate<Audience> filter2) {
        return this.registry.values().stream().flatMap(Collection::stream).filter(filter2).toList();
    }
}

