/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.advancements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minestom.server.Viewable;
import net.minestom.server.advancements.Advancement;
import net.minestom.server.advancements.AdvancementRoot;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.server.play.AdvancementsPacket;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancementTab
implements Viewable {
    private static final Map<UUID, Set<AdvancementTab>> PLAYER_TAB_MAP = new HashMap<UUID, Set<AdvancementTab>>();
    private final Set<Player> viewers = new HashSet<Player>();
    private final AdvancementRoot root;
    private final Map<Advancement, Advancement> advancementMap = new HashMap<Advancement, Advancement>();
    protected final AdvancementsPacket removePacket;

    protected AdvancementTab(@NotNull String rootIdentifier, @NotNull AdvancementRoot root) {
        this.root = root;
        this.cacheAdvancement(rootIdentifier, root, null);
        this.removePacket = new AdvancementsPacket(false, List.of(), List.of(rootIdentifier), List.of());
    }

    @Nullable
    public static Set<AdvancementTab> getTabs(@NotNull Player player) {
        return PLAYER_TAB_MAP.getOrDefault(player.getUuid(), null);
    }

    @NotNull
    public AdvancementRoot getRoot() {
        return this.root;
    }

    public void createAdvancement(@NotNull String identifier, @NotNull Advancement advancement, @NotNull Advancement parent) {
        Check.stateCondition(!this.advancementMap.containsKey(parent), "You tried to set a parent which doesn't exist or isn't registered");
        this.cacheAdvancement(identifier, advancement, parent);
        if (!this.getViewers().isEmpty()) {
            this.sendPacketToViewers(advancement.getUpdatePacket());
        }
    }

    @NotNull
    protected AdvancementsPacket createPacket() {
        ArrayList<AdvancementsPacket.AdvancementMapping> mappings = new ArrayList<AdvancementsPacket.AdvancementMapping>();
        ArrayList<AdvancementsPacket.ProgressMapping> progressMappings = new ArrayList<AdvancementsPacket.ProgressMapping>();
        for (Advancement advancement : this.advancementMap.keySet()) {
            mappings.add(advancement.toMapping());
            progressMappings.add(advancement.toProgressMapping());
        }
        return new AdvancementsPacket(false, mappings, List.of(), progressMappings);
    }

    private void cacheAdvancement(@NotNull String identifier, @NotNull Advancement advancement, @Nullable Advancement parent) {
        Check.stateCondition(advancement.getTab() != null, "You tried to add an advancement already linked to a tab");
        advancement.setTab(this);
        advancement.setIdentifier(identifier);
        advancement.setParent(parent);
        advancement.updateCriteria();
        this.advancementMap.put(advancement, parent);
    }

    @Override
    public synchronized boolean addViewer(@NotNull Player player) {
        boolean result2 = this.viewers.add(player);
        if (!result2) {
            return false;
        }
        player.sendPacket(this.createPacket());
        this.addPlayer(player);
        return true;
    }

    @Override
    public synchronized boolean removeViewer(@NotNull Player player) {
        if (!this.isViewer(player)) {
            return false;
        }
        if (!player.isRemoved()) {
            player.sendPacket(this.removePacket);
        }
        this.removePlayer(player);
        return this.viewers.remove(player);
    }

    @Override
    @NotNull
    public Set<Player> getViewers() {
        return this.viewers;
    }

    private void addPlayer(@NotNull Player player) {
        Set tabs = PLAYER_TAB_MAP.computeIfAbsent(player.getUuid(), p -> new CopyOnWriteArraySet());
        tabs.add(this);
    }

    private void removePlayer(@NotNull Player player) {
        UUID uuid = player.getUuid();
        if (!PLAYER_TAB_MAP.containsKey(uuid)) {
            return;
        }
        Set<AdvancementTab> tabs = PLAYER_TAB_MAP.get(uuid);
        tabs.remove(this);
        if (tabs.isEmpty()) {
            PLAYER_TAB_MAP.remove(uuid);
        }
    }
}

