/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.advancements;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.minestom.server.advancements.AdvancementTab;
import net.minestom.server.advancements.FrameType;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.network.packet.server.play.AdvancementsPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Advancement {
    protected AdvancementTab tab;
    private boolean achieved;
    private Component title;
    private Component description;
    private ItemStack icon;
    private FrameType frameType;
    private String background;
    private boolean toast;
    private boolean hidden;
    private float x;
    private float y;
    private String identifier;
    private Advancement parent;
    private AdvancementsPacket.Criteria criteria;

    public Advancement(@NotNull Component title, Component description2, @NotNull ItemStack icon, @NotNull FrameType frameType, float x, float y) {
        this.title = title;
        this.description = description2;
        this.icon = icon;
        this.frameType = frameType;
        this.x = x;
        this.y = y;
    }

    public Advancement(@NotNull Component title, @NotNull Component description2, @NotNull Material icon, @NotNull FrameType frameType, float x, float y) {
        this(title, description2, ItemStack.of(icon), frameType, x, y);
    }

    public boolean isAchieved() {
        return this.achieved;
    }

    public Advancement setAchieved(boolean achieved) {
        this.achieved = achieved;
        this.update();
        return this;
    }

    @Nullable
    public AdvancementTab getTab() {
        return this.tab;
    }

    protected void setTab(@NotNull AdvancementTab tab) {
        this.tab = tab;
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(@NotNull Component title) {
        this.title = title;
        this.update();
    }

    @NotNull
    public Component getDescription() {
        return this.description;
    }

    public void setDescription(@NotNull Component description2) {
        this.description = description2;
        this.update();
    }

    @NotNull
    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(@NotNull ItemStack icon) {
        this.icon = icon;
        this.update();
    }

    public boolean hasToast() {
        return this.toast;
    }

    public Advancement showToast(boolean toast) {
        this.toast = toast;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Advancement setHidden(boolean hidden) {
        this.hidden = hidden;
        this.update();
        return this;
    }

    @NotNull
    public FrameType getFrameType() {
        return this.frameType;
    }

    public void setFrameType(FrameType frameType) {
        this.frameType = frameType;
        this.update();
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
        this.update();
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
        this.update();
    }

    protected void setBackground(String background) {
        this.background = background;
    }

    protected String getIdentifier() {
        return this.identifier;
    }

    protected void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Nullable
    protected Advancement getParent() {
        return this.parent;
    }

    protected void setParent(Advancement parent) {
        this.parent = parent;
    }

    @NotNull
    protected AdvancementsPacket.ProgressMapping toProgressMapping() {
        AdvancementsPacket.AdvancementProgress advancementProgress = new AdvancementsPacket.AdvancementProgress(List.of(this.criteria));
        return new AdvancementsPacket.ProgressMapping(this.identifier, advancementProgress);
    }

    @NotNull
    protected AdvancementsPacket.DisplayData toDisplayData() {
        return new AdvancementsPacket.DisplayData(this.title, this.description, this.icon, this.frameType, this.getFlags(), this.background, this.x, this.y);
    }

    @NotNull
    protected AdvancementsPacket.AdvancementMapping toMapping() {
        Advancement parent = this.getParent();
        String parentIdentifier = parent != null ? parent.getIdentifier() : null;
        AdvancementsPacket.Advancement adv = new AdvancementsPacket.Advancement(parentIdentifier, this.toDisplayData(), List.of(this.criteria.criterionIdentifier()), List.of(new AdvancementsPacket.Requirement(List.of(this.criteria.criterionIdentifier()))));
        return new AdvancementsPacket.AdvancementMapping(this.getIdentifier(), adv);
    }

    protected AdvancementsPacket getUpdatePacket() {
        return new AdvancementsPacket(false, List.of(this.toMapping()), List.of(), List.of(this.toProgressMapping()));
    }

    protected void update() {
        this.updateCriteria();
        if (this.tab != null) {
            this.tab.sendPacketsToViewers(this.tab.removePacket, this.tab.createPacket());
        }
    }

    protected void updateCriteria() {
        Long achievedDate = this.achieved ? Long.valueOf(System.currentTimeMillis()) : null;
        AdvancementsPacket.CriterionProgress progress = new AdvancementsPacket.CriterionProgress(achievedDate);
        this.criteria = new AdvancementsPacket.Criteria(this.identifier, progress);
    }

    private int getFlags() {
        byte result2 = 0;
        if (this.background != null) {
            result2 = (byte)(result2 | 1);
        }
        if (this.hasToast()) {
            result2 = (byte)(result2 | 2);
        }
        if (this.isHidden()) {
            result2 = (byte)(result2 | 4);
        }
        return result2;
    }
}

