/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.dependencies;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minestom.dependencies.DependencyGetter;
import net.minestom.dependencies.DependencyResolver;
import net.minestom.dependencies.ResolvedDependency;
import net.minestom.dependencies.UnresolvedDependencyException;
import net.minestom.dependencies.maven.MavenRepository;
import net.minestom.dependencies.maven.MavenResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lnet/minestom/dependencies/DependencyGetter;", "", "()V", "resolverList", "", "Lnet/minestom/dependencies/DependencyResolver;", "resolvers", "", "getResolvers", "()Ljava/util/List;", "addMavenResolver", "repositories", "Lnet/minestom/dependencies/maven/MavenRepository;", "addResolver", "resolver", "get", "Lnet/minestom/dependencies/ResolvedDependency;", "id", "", "targetFolder", "Ljava/io/File;", "DependencyGetter"})
public final class DependencyGetter {
    private final List<DependencyResolver> resolverList;

    @NotNull
    public final List<DependencyResolver> getResolvers() {
        return this.getResolvers();
    }

    @NotNull
    public final DependencyGetter addResolver(@NotNull DependencyResolver resolver) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Collection collection = this.resolverList;
        boolean bl = false;
        collection.add(resolver);
        return this;
    }

    @NotNull
    public final DependencyGetter addMavenResolver(@NotNull List<MavenRepository> repositories) {
        Intrinsics.checkNotNullParameter(repositories, "repositories");
        return this.addResolver(new MavenResolver(repositories));
    }

    @NotNull
    public final ResolvedDependency get(@NotNull String id2, @NotNull File targetFolder) {
        Intrinsics.checkNotNullParameter(id2, "id");
        Intrinsics.checkNotNullParameter(targetFolder, "targetFolder");
        for (DependencyResolver resolver : this.resolverList) {
            try {
                return resolver.resolve(id2, targetFolder);
            }
            catch (UnresolvedDependencyException unresolvedDependencyException) {
            }
        }
        throw (Throwable)new UnresolvedDependencyException("Could not find " + id2 + " inside resolver list: " + CollectionsKt.joinToString$default(this.resolverList, null, null, null, 0, null, get.1.INSTANCE, 31, null));
    }

    public DependencyGetter() {
        boolean bl = false;
        this.resolverList = new ArrayList();
    }
}

